(function(){
    var EmailTemplates = function() {

        return {

            init: function() {
                var grid = new Datatable();

                grid.init({
                    src: $("#datatable-emails"),
                    onSuccess: function (grid) {
                        // execute some code after table records loaded
                    },
                    onError: function (grid) {
                        // execute some code on network or other general error
                    },
                    loadingMessage: 'Loading...',
                    dataTable: {
                        "columns": [
                            { "title": "ID", "data": "id", "sortable": true },
                            { "title": "Title", "data": "title", "sortable": true },
                            { "title": "Short Content", "data": "content", "sortable": false },
                            { "title": "System Email", "data": null, "sortable": false },
                            { "title": "Created", "data": "created_at", "sortable": true },
                            { "title": "Actions", "data": null, "sortable": false }
                        ],
                        "columnDefs": [
                            {
                                "targets": [3],
                                "render": function( data, type, full, meta ) {
                                    return ( full.path !== null ) ? '<i class="fa fa-check"></i>' : '<i class="fa fa-cross"></i>';
                                }
                            },
                            {
                                "targets": [5],
                                "render": function ( data, type, full, meta ) {
                                    var buttons = '<a href="' + url_admin_emailtempltes_edit + '/' + full.id + '" target="_blank" class="btn btn-sm yellow" id="edit"><i class="fa fa-pencil"></i> Edit</a>';

                                    if( full.path == null ) buttons = buttons + '<button class="btn btn-sm red" id="remove" data-id="' + full.id + '"><i class="fa fa-close"></i> Delete</button>';

                                    return buttons;
                                }
                            }
                        ],
                        "pageLength": 25, // default record count per page
                        "ajax": {
                            "url": ajax_emailtemplates_dt // ajax source,
                        } ,
                        "order": [
                            [0, "asc"]
                        ] // set first column as a default sort by asc
                    }
                });

                $('#datatable-emails').on('click', 'tbody td:last-child button#remove', function(e){
                    e.preventDefault();

                    var self = $(this);

                    App.ajax({
                        url: ajax_emailtemplates_delete,
                        type: 'POST',
                        data: {
                            id: self.data('id')
                        }
                    }, function( data ){
                        grid.getDataTable().ajax.reload();
                    });
                });
            }
        }

    }();

    $(document).ready(function() {
        EmailTemplates.init();
    });

})();