(function(){
	var Loans = function() {

    return {

        init: function() {
        	var dt = $('#datatable-loans').on('xhr.dt', function ( e, settings, json ) {
		        $('#filterBtn').prop('disabled', false);
		    	} ).DataTable( {
						ajax: {
							url: ajax_loans_dt,
							type: 'POST',
							data: function(d) {
								d.startDate = $('#startDate').val();
								d.endDate = $('#endDate').val();
								d.id = $('#loanID').val();
								d.borrowerID = $('#borrowerID').val();
								d.lenderID = $('#lenderID').val();
								d.amount = $('#amount').val();
								d.interest = $('#interest').val();
								d.monthly_payment = $('#monthly_payment').val();
								//d.purpose = $('#purpose').val();
								d.status = $('#status').val();
								d.relisted = $('#relisted').bootstrapSwitch('state');
								d.notice = $('#notice').bootstrapSwitch('state');
							}
						},
						lengthMenu: [ 25, 50, 75, 100 ],
						pageLength: 25,
						serverSide: true,
						retrieve: true,
						paging: true,
						searching: false,
						"columns": [
				      { "title": "ID", "data": "id" },
				      { "title": "Borrower", "data": null },
				      { "title": "Investor", "data": null },
				      { "title": "Rate", "data": "rate_id" },
				      { "title": "Term", "data": null },
				      { "title": "Amount", "data": null },
				      { "title": "Interest", "data": null },
				      { "title": "Payment", "data": null },
				      { "title": "Status", "data": "status" },
				      { "title": "Created", "data": "created_at" }
				    ],
				    "columnDefs": [
							{
					 			"targets": [1],
					 			"render": function ( data, type, full, meta ) {
					 				return full.borrowerName + ' (#' + full.borrowerID + ')';
					 			}
							},
							{
					 			"targets": [2],
					 			"render": function ( data, type, full, meta ) {
					 				if( full.lenderID == null )
					 					return '-';
					 				else
					 					return full.lenderName + ' (#' + full.lenderID + ')';
					 			}
							},
							{
					 			"targets": [4],
					 			"render": function ( data, type, full, meta ) {
					 				return full.term  + ' months';
					 			}
							},
							{
					 			"targets": [5],
					 			"render": function ( data, type, full, meta ) {
					 				return '$' + full.amount;
					 			}
							},
							{
					 			"targets": [6],
					 			"render": function ( data, type, full, meta ) {
					 				return full.interest  + ' %';
					 			}
							},
							{
					 			"targets": [7],
					 			"render": function ( data, type, full, meta ) {
					 				return '$' + full.monthly_payment;
					 			}
							}
						]
					});

			$('#betweenFilter').daterangepicker({
	            format: 'MM/DD/YYYY',
	            separator: ' to ',
	            startDate: moment().subtract(1, 'month'),
	            endDate: moment(),
	            minDate: '01/01/2012',
	            maxDate: '12/31/2018'
            },
            function (start, end) {
              $('#startDate').val( start.format('YYYY-MM-D') );
              $('#endDate').val( end.format('YYYY-MM-D') );
              $('#betweenFilter input').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
          	});

			$('#filterForm').submit(function(e){
	            e.preventDefault();
	            
	            $('#filterBtn').prop('disabled', 'disabled');
	            var range = $('#betweenFilter input').val().toString(), srange = range.split(' - ');

	            if( range == '' || range.length < 1 || srange.length !== 2 || !moment(srange[0]).isValid() || !moment(srange[0]).isValid(srange[1]) ) {
	            	$('#startDate').val('');
	              	$('#endDate').val('');
	              	$('#betweenFilter input').val('');
	            }

	            dt.ajax.reload();
	        });
        }
    };

	}();

	$(document).ready(function() {
		Loans.init();
	});

})();