(function(){
	var Notes = function() {

    return {

        init: function() {
        	var dt = $('#datatable-notes').on('xhr.dt', function ( e, settings, json ) {
		        $('#filterBtn').prop('disabled', false);
		    	} ).DataTable( {
						ajax: {
							url: ajax_notes_dt,
							type: 'POST',
							data: function(d) {
								d.id = $('#noteID').val();
								d.loanID = $('#loanID').val();
								d.userID = $('#userID').val();
								d.amount = $('#amount').val();
								d.interest = $('#interest').val();
								d.current_amount = $('#current_amount').val();
								d.status = $('#status').val();
								d.sold_at = $('#sold_at').val();
							}
						},
						lengthMenu: [ 25, 50, 75, 100 ],
						pageLength: 25,
						serverSide: true,
						retrieve: true,
						paging: true,
						searching: false,
						"columns": [
				      { "title": "ID", "data": "id" },
				      { "title": "Loan ID", "data": "loanID" },
				      { "title": "User", "data": null },
				      { "title": "Amount", "data": null },
				      { "title": "Interest", "data": null },
				      { "title": "Current Amount", "data": null },
				      { "title": "Status", "data": "status" },
				      { "title": "Sold", "data": "sold_at" },
				      { "title": "Actions", "data": null }
				    ],
				    "columnDefs": [
							{
					 			"targets": [2],
					 			"render": function ( data, type, full, meta ) {
					 				return full.username + ' (#' + full.user_id + ')';
					 			}
							},
							{
					 			"targets": [3],
					 			"render": function ( data, type, full, meta ) {
					 				return '$ ' + full.amount;
					 			}
							},
							{
					 			"targets": [4],
					 			"render": function ( data, type, full, meta ) {
					 				return '$ ' + full.interest;
					 			}
							},
							{
					 			"targets": [5],
					 			"render": function ( data, type, full, meta ) {
					 				return '$ ' + full.current_amount;
					 			}
							},
							{
					 			"targets": [8],
					 			"render": function ( data, type, full, meta ) {
					 				return '';
					 			}
							}
						]
					});



			$('#filterForm').submit(function(e){
	            e.preventDefault();
	            
	            $('#filterBtn').prop('disabled', 'disabled');

	            dt.ajax.reload();
	        });
        }
    };

	}();

	$(document).ready(function() {
		Notes.init();
	});

})();