(function(){
   var PendingDeposits = function() {
      var dt;
      var rows_selected = [];

      function updateDataTableSelectAllCtrl(table){
         var $table             = table.table().node();
         var $chkbox_all        = $('tbody input[type="checkbox"]', $table);
         var $chkbox_checked    = $('tbody input[type="checkbox"]:checked', $table);
         var chkbox_select_all  = $('thead input[name="select_all"]', $table).get(0);

         // If none of the checkboxes are checked
         if($chkbox_checked.length === 0){
            chkbox_select_all.checked = false;
            if('indeterminate' in chkbox_select_all){
               chkbox_select_all.indeterminate = false;
            }

         // If all of the checkboxes are checked
         } else if ($chkbox_checked.length === $chkbox_all.length){
            chkbox_select_all.checked = true;
            if('indeterminate' in chkbox_select_all){
               chkbox_select_all.indeterminate = false;
            }

         // If some of the checkboxes are checked
         } else {
            chkbox_select_all.checked = true;
            if('indeterminate' in chkbox_select_all){
               chkbox_select_all.indeterminate = true;
            }
         }

         $('span#selectedCount').html( rows_selected.length );
      };

    return {

        init: function() {
         dt = $('#pendingDeposits').DataTable( {
                  ajax: {
                     url: ajax_pendingDeposits_dt,
                     type: 'POST'
                  },
                  lengthMenu: [ 25, 50, 75, 100 ],
                  pageLength: 25,
                  serverSide: true,
                  retrieve: true,
                  paging: true,
                  searching: false,
                'order': [[1, 'asc']],
                'rowCallback': function(row, data, dataIndex){
                     // Get row ID
                     var rowId = data[0];

                     // If row ID is in the list of selected row IDs
                     if($.inArray(rowId, rows_selected) !== -1){
                        $(row).find('input[type="checkbox"]').prop('checked', true);
                        $(row).addClass('selected');
                     }
               },
                "columnDefs": [
                     {
                        'targets': 0,
                        'searchable': false,
                        'orderable': false,
                        'width': '1%',
                        'className': 'dt-body-center',
                        "render": function( data, type, full, meta ) {
                           return '<input type="checkbox">';
                        }
                     },
                     {
                        'targets': 1,
                        'orderable': true,
                        'data': 'id'
                     },
                     {
                        'targets': 2,
                        'orderable': true,
                        'data': null,
                        'render': function( data, type, full, meta ) {
                           return '<img src="' + processorImgUrl + full.processor_id + '.gif" />'
                        }
                     },
                     {
                        'targets': 3,
                        'orderable': true,
                        'data': null,
                        'render': function( data, type, full, meta ) {
                           return '<a href="#" class="userPopup" data-id="' + full.user_id + '">' + full.username + ' (#' + full.user_id + ')</a>';
                        }
                     },
                     {
                        'targets': 4,
                        'orderable': true,
                        'data': null,
                        'render': function( data, type, full, meta ) {
                           return full.typeName;
                        }
                     },
                     {
                        'targets': 5,
                        'orderable': true,
                        'data': 'fee'
                     },
                     {
                        'targets': 6,
                        'orderable': true,
                        'data': 'amount'
                     },
                     {
                        'targets': 7,
                        'orderable': false,
                        'data': null,
                        'class': 'noteCell',
                        'render': function( full ) {
                            if( full.bitcoin_txid && full.bitcoin_txid !== null ) {
                              var url = "<a href=\'" + full.bitcoin_txid + "\' target=\'_blank\'>" + full.bitcoin_txid + "</a>";
                              return '<a tabindex="0" data-html="true" href="javascript:;" class="popovers" data-container="body" data-content="' + url + '" data-placement="top" role="button"  data-original-title="Bitcoin TX ID">' + full.bitcoin_txid.trimToLength( 25 ) + '</a>';
                            }

                            return full.note;
                        }
                     },
                     {
                        'targets': 8,
                        'orderable': true,
                        'data': 'created_at'
                     },
                     {
                        'targets': 9,
                        'searchable': false,
                        'orderable': false,
                        'data': null,
                        'render': function( full ) {
                           return '<button class="btn yellow approveBtn btn-sm" style="margin-right:10px" data-action="1"><i class="fa fa-check"></i> Approve</button><button class="btn red declineBtn btn-sm" data-action="2"><i class="fa fa-close"></i> Decline</button>';
                        }
                     }
                  ]
               });

         $('#pendingDeposits tbody').on('click', 'tr td a.userPopup', function(e) {
            e.preventDefault();
            var id = $(this).data('id');

            App.userInfo( id, userInfoUrl );
         });

         $('#pendingDeposits tbody').on('click', 'tr td a.popovers', function(e) {
           $(this).popover({
             html: true,
             template: '<div class="popover" role="tooltip"><div class="arrow"></div><h3 class="popover-title"></h3><a href="javascript:;" class="popover-close-btn"><i class="fa fa-close"></i></a><div class="popover-content"></div></div>'
           });
         });

         $('body').on('click', '.popover .popover-close-btn', function(e) {
           $(this).parents('.popover').popover('hide');
         });

         $('#pendingDeposits tbody').on('click', 'input[type="checkbox"]', function(e){
            var $row = $(this).closest('tr');

            // Get row data
            var data = dt.row($row).data();

            // Get row ID
            var rowId = data.id;

            // Determine whether row ID is in the list of selected row IDs
            var index = $.inArray(rowId, rows_selected);

            // If checkbox is checked and row ID is not in list of selected row IDs
            if(this.checked && index === -1){
               rows_selected.push(rowId);

            // Otherwise, if checkbox is not checked and row ID is in list of selected row IDs
            } else if (!this.checked && index !== -1){
               rows_selected.splice(index, 1);
            }

            if(this.checked){
               $row.addClass('selected');
            } else {
               $row.removeClass('selected');
            }

            // Update state of "Select all" control
            updateDataTableSelectAllCtrl(dt);

            // Prevent click event from propagating to parent
            e.stopPropagation();
         });

         // Handle click on table cells with checkboxes
         $('#pendingDeposits').on('click', 'tbody td:not(:last-child):not(.noteCell), thead th:first-child', function(e){
            $(this).parent().find('input[type="checkbox"]').trigger('click');
         });

         // Handle click on "Select all" control
         $('thead input[name="select_all"]', dt.table().container()).on('click', function(e){
            if(this.checked){
               $('#pendingDeposits tbody input[type="checkbox"]:not(:checked)').trigger('click');
            } else {
               $('#pendingDeposits tbody input[type="checkbox"]:checked').trigger('click');
            }

            // Prevent click event from propagating to parent
            e.stopPropagation();
         });

         // Handle table draw event
         dt.on('draw', function(){
            // Update state of "Select all" control
            updateDataTableSelectAllCtrl(dt);
         });

         $('#pendingDeposits').on('click', 'tbody tr td:last-child .approveBtn, tbody tr td:last-child .declineBtn', function(e){
            var self = $(this), $row = $(this).closest('tr'), data = dt.row( $row ).data(), rowId = data.id, index = $.inArray( rowId, rows_selected ), action = self.data('action');

            $('.bulkBtn').prop('disabled', 'disabled');

            App.ajax({
                  url: ajax_pendingDeposits_action,
                  method: 'POST',
                  data: {
                     action: action,
                     id: rowId
                  }
               }, function( data ) {

                  if( data ) {
                     dt.ajax.reload(function(){

                        if ( index > -1 ){
                           rows_selected.splice( index, 1 );
                           updateDataTableSelectAllCtrl(dt);
                        }

                     });
                  }

                  $('.bulkBtn').prop('disabled', false);
               });

         });

         $('.bulkBtn').on('click', function(e){
            var self = $( this );

            if( rows_selected.length > 0 ) {

               $('.bulkBtn').prop('disabled', 'disabled');

               var action = self.data('action');

               App.ajax({
                  url: ajax_pendingDeposits_action,
                  method: 'POST',
                  data: {
                     action: action,
                     id: rows_selected
                  }
               }, function( data ) {
                  if( data ) {
                     rows_selected = [];
                     dt.ajax.reload();
                     $('.bulkBtn').prop('disabled', false);
                  }
               });
            }

         });

        }
    };

   }();

   $(document).ready(function() {
      PendingDeposits.init();
   });

})();
