(function(){
	var SummaryAccounting = function() {
		var icons = ['','briefcase','briefcase','chart_curve','group','arrow_switch','application_add','briefcase','package','arrow_switch','application_delete','money_delete'];
		var names = ['', 'E-Wallet Fund via Processor','E-Wallet Fund via Cashout','Interest','Commission','Transfer From Member','Misc Account Credits','E-Wallet Cashout','Purchase Plans','Transfer To Member','Misc Account Debits','Processor Cashout'];

    return {

    	init: function() {
						$('#betweenFilter').daterangepicker({
	            format: 'MM/DD/YYYY',
	            separator: ' to ',
	            startDate: moment().subtract(1, 'month'),
	            endDate: moment(),
	            minDate: '01/01/2012',
	            maxDate: '12/31/2018'
            },
            function (start, end) {
              $('#startDate').val( start.format('YYYY-MM-D') );
              $('#endDate').val( end.format('YYYY-MM-D') );
              $('#betweenFilter input').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
          	});

					$('#filterForm').submit(function(e){
	            e.preventDefault();
	            
	            $('#filterBtn').prop('disabled', 'disabled');
	            var range = $('#betweenFilter input').val().toString(), srange = range.split(' - ');

	            if( range == '' || range.length < 1 || srange.length !== 2 || !moment(srange[0]).isValid() || !moment(srange[0]).isValid(srange[1]) ) {
	            		$('#startDate').val('');
	              	$('#endDate').val('');
	              	$('#betweenFilter input').val('');
	            }

	            var startDate = $('#startDate').val();
              var endDate = $('#endDate').val();

	            App.ajax({
	            	url: ajax_accounting_data,
	            	type: 'POST',
	            	data: {
	            		startDate: startDate,
	            		endData: endDate
	            	}
	            }, function( data ){
	            	$('#filterBtn').prop('disabled', false);

	            	console.log(data);

	            	var tables = {
	            		credit: $('table.credit'),
	            		debit: $('table.debit'),
	            		cashout: $('table.cashout')
	            	};

	            	for( var t in tables ) {
	            		var table = tables[ t ];

	            		for( var i in data[ t ] ) {
	            			var item = data[ t ][ i ];

	            			table.find('tr.' + i).find('td.value').html( item );
	            		}

	            	}

	            });
	        });

	        $('#filterForm').trigger('submit');
        }
    };
  }();

	$(document).ready(function() {
		SummaryAccounting.init();
	});

})();