(function(){
	var UsersPackages = function() {

    return {

    	init: function() {
    		var dt = $('#datatable-packages').on('xhr.dt', function ( e, settings, json ) {
		        $('#searchBtn').prop('disabled', false);
		    	} ).DataTable( {
					ajax: {
						url: ajax_packages_dt,
						type: 'POST',
						data: function(d) {
							d.source = "packages";
			                d.id = $('#id').val();
			                d.user_id = $('#userID').val();
			                d.type = $('#type').val();
			                d.amount = $('#amount').val();
			                d.startDate = $('#startDate').val();
			                d.endDate = $('#endDate').val();
						}
					},
					lengthMenu: [ 25, 50, 75, 100 ],
					pageLength: 25,
					serverSide: true,
					retrieve: true,
					paging: true,
					searching: false,
					"columns": [
		              { "title": "Package ID", "sortable": true, "data": "id" },
		              { "title": "Member", "data": "user_id", "sortable": true },
		              { "title": "Package Type", "data": "token_id", "sortable": false },
		              { "title": "Invested Amount", "data": "invested_amount" },
		              { "title": "Created", "data": "created_at" }
				    ],
				    "columnDefs": [
		              {
		                  "targets": [1],
		                  "render": function ( data, type, full, meta ) {
		                      return full.username + ' (#' + full.user_id + ')';
		                  }
		              },
		              {
		                  "targets": [2],
		                  "render": function ( data, type, full, meta ) {
		                      return full.tokenName;
		                  }
		              }
		            ]
				});


			$('#betweenFilter').daterangepicker({
	            format: 'MM/DD/YYYY',
	            separator: ' to ',
	            startDate: moment().subtract(1, 'month'),
	            endDate: moment(),
	            minDate: '01/01/2012',
	            maxDate: '12/31/2018'
            },
            function (start, end) {
              $('#startDate').val( start.format('YYYY-MM-D') );
              $('#endDate').val( end.format('YYYY-MM-D') );
              $('#betweenFilter input').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
          	});

					$('#filterForm').submit(function(e){
	            e.preventDefault();
	            
	            $('#filterBtn').prop('disabled', 'disabled');
	            var range = $('#betweenFilter input').val().toString(), srange = range.split(' - ');

	            if( range == '' || range.length < 1 || srange.length !== 2 || !moment(srange[0]).isValid() || !moment(srange[0]).isValid(srange[1]) ) {
	            		$('#startDate').val('');
	              	$('#endDate').val('');
	              	$('#betweenFilter input').val('');
	            }

	            dt.ajax.reload();
	        });

	        $(".userSearch").select2({
			      tags: false,
			      multiple: false,
			      width: '400px',
			      ajax: {
			          url: ajax_admin_usersearch_select2,
			          dataType: "json",
			          type: "POST",
			          data: function(params) {
			              return {
			                  q: params.term, // search term
			                  page: params.page
			              };
			          },
			          processResults: function (data) {
			              var results = [];
			              $.each(data.data, function (index, user) {
			                  results.push({
			                      id: user.id,
			                      text: user.username
			                  });
			              });

			              return {
			                  results: results
			              };
			          },
			          formatResult: function(element){
					          return element.text + ' (' + element.id + ')';
					      },
					      formatSelection: function(element){
					          return element.text + ' (' + element.id + ')';
      					},
			          cache: true
			      }
			  	});

        }
    };
  }();

	$(document).ready(function() {
		UsersPackages.init();
	});

})();