(function(){
   var UsersProcessors = function() {
      var dt;

    return {

        init: function() {
         dt = $('#userBanks').DataTable( {
                  ajax: {
                     url: ajax_usersBanks_dt,
                     type: 'POST',
                     data: {
                        userID: userID
                     }
                  },
                  lengthMenu: [ 25, 50, 75, 100 ],
                  pageLength: 25,
                  serverSide: true,
                  retrieve: true,
                  paging: true,
                  searching: false,
                'order': [[0, 'asc']],
                "columnDefs": [
                     {
                        'targets': 0,
                        'orderable': true,
                        'data': 'id'
                     },
                     {
                        'targets': 1,
                        'orderable': false,
                        'data': 'profileName'
                     },
                     {
                        'targets': 2,
                        'orderable': true,
                        'data': null,
                        'render': function( data, type, full, meta ) {
                           return '<img src="' + processorImgUrl + full.processor_id + '.gif" />'
                        }
                     },
                     {
                        'targets': 3,
                        'orderable': true,
                        'data': 'created_at'
                     },
                     {
                        'targets': 4,
                        'searchable': false,
                        'orderable': false,
                        'data': null,
                        'render': function( full ) {
                           return '<button class="btn yellow viewBP btn-sm" style="margin-right:10px" target="_blank"><i class="fa fa-eye"></i> View</button><button class="btn red declineBtn btn-sm" data-action="2"><i class="fa fa-close"></i> Delete</button>';
                        }
                     }
                  ]
               });

         $('#userBanks').on('click', 'tbody tr td:last-child .viewBP', function(e){
            var self = $(this), $row = $(this).closest('tr'), data = dt.row( $row ).data(), rowId = data.id, action = self.data('action');

            App.popUp( url_bankProfile, [rowId], 'User Information (#' + userID + ') - Bank Profiles');
         });

         $('#userBanks').on('click', 'tbody tr td:last-child .declineBtn', function(e){
            var self = $(this), $row = $(this).closest('tr'), data = dt.row( $row ).data(), rowId = data.id, action = self.data('action');

            App.ajax({
                  url: ajax_usersBanks_action,
                  method: 'POST',
                  data: {
                     action: action,
                     id: rowId
                  }
               }, function( data ) {

                  if( data ) {
                     dt.ajax.reload();
                  }
               });

         });

        }
    };

   }();

   $(document).ready(function() {
      UsersProcessors.init();
   });

})();
