(function() {
	var Users = function() {
    return {

    	init: function() {
				var dt = $('#datatable-users').on('xhr.dt', function ( e, settings, json ) {

		        $('#searchBtn').prop('disabled', false);

		    	} ).DataTable( {
						ajax: {
							url: ajax_users_dt,
							type: 'POST',
							data: function(d) {
                d.userID = $('#userID').val();
                d.status = $('#status').val();
                d.startDate = $('#startDate').val();
                d.endDate = $('#endDate').val();
							}
						},
						lengthMenu: [ 25, 50, 75, 100 ],
						pageLength: 25,
						serverSide: true,
						retrieve: true,
						paging: true,
						searching: false,
						"columns": [
              { "title": "ID", "sortable": true, "data": "id" },
              { "title": "Name", "data": "name", "sortable": true },
              { "title": "Username", "data": "username", "sortable": true },
              { "title": "Email", "data": "email", "sortable": true },
              { "title": "Status", "data": "status", "sortable": true },
              { "title": "E-Wallet", "data": "ewalletBalance", "sortable": true },
              { "title": "Sign up", "data": "created_at" },
              { "title": "Actions", "data": null }
				    ],
				    "columnDefs": [
              {
                  'targets': 7,
                  'orderable': true,
                  'data': null,
                  'render': function( data, type, full, meta ) {
                     return '<button class="btn yellow viewUser" data-id="' + full.id + '"><i class="fa fa-eye"></i> View</button>'
                  }
               },
            ]
					});

      $('#datatable-users tbody').on('click', 'tr td .viewUser', function(e) {
            e.preventDefault();
            var id = $(this).data('id');

            App.userInfo( id, userInfoUrl );
         });

			$('#betweenFilter').daterangepicker({
	            format: 'MM/DD/YYYY',
	            separator: ' to ',
	            startDate: moment().subtract(1, 'month'),
	            endDate: moment(),
	            minDate: '01/01/2012',
	            maxDate: '12/31/2018'
            },
            function (start, end) {
              $('#startDate').val( start.format('YYYY-MM-D') );
              $('#endDate').val( end.format('YYYY-MM-D') );
              $('#betweenFilter input').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
          	});

			$('#filterForm').submit(function(e){
	            e.preventDefault();

	            $('#filterBtn').prop('disabled', 'disabled');
	            var range = $('#betweenFilter input').val().toString(), srange = range.split(' - ');

	            if( range == '' || range.length < 1 || srange.length !== 2 || !moment(srange[0]).isValid() || !moment(srange[0]).isValid(srange[1]) ) {
	            	$('#startDate').val('');
	              	$('#endDate').val('');
	              	$('#betweenFilter input').val('');
	            }

	            dt.ajax.reload();
	        });

          $(".userSearch").select2({
            tags: false,
            multiple: false,
						maximumSelectionSize: 10,
						minimumInputLength: 1,
            width: '400px',
            ajax: {
                url: ajax_admin_usersearch_select2,
                dataType: "json",
                type: "POST",
                data: function(params) {
                    return {
                        q: params.term, // search term
                        page: params.page
                    };
                },
                processResults: function (data) {
                    var results = [];
                    $.each(data.data, function (index, user) {
                        results.push({
                            id: user.id,
                            text: user.username
                        });
                    });

                    return {
                        results: results
                    };
                },
                cache: true
            }
          });
        }
    };
  }();

	$(document).ready(function() {
		Users.init();
	});

})();
