﻿// (c) ammap.com | SVG (in JSON format) map of Honduras - Low
// areas: {id:"HN-AT"},{id:"HN-CH"},{id:"HN-CL"},{id:"HN-CM"},{id:"HN-CP"},{id:"HN-CR"},{id:"HN-EP"},{id:"HN-FM"},{id:"HN-GD"},{id:"HN-IN"},{id:"HN-IB"},{id:"HN-LP"},{id:"HN-LE"},{id:"HN-OC"},{id:"HN-OL"},{id:"HN-SB"},{id:"HN-VA"},{id:"HN-YO"}
AmCharts.maps.hondurasLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"-89.350244",
				"topLatitude":"16.517355",
				"rightLongitude":"-83.126949",
				"bottomLatitude":"12.984061"
			}
		},
		"g":{
			"path":[
				{
					"id":"HN-AT",
					"title":"Atlántida",
					"d":"M199.48,176.39l-3.14,2.39l1.3,3.54l7.76,7.85l3.39,2.09l4.31,1.37l4.34,-0.92l1.46,-3.01l4.28,-0.52l2.03,-3.44l17.99,5.33l19.04,3.11l4.43,0.03l5.58,1.77l6.46,0.72l2.69,-1.01l5.92,-0.42l5.99,-3.76l0.35,1.08l1.01,-1.05l5.23,1.21l5.16,0.13l4.56,-1.18l12.58,-1.08l1.55,-0.82l0,0l1.27,1.9l3.64,2.33l-1,0.95l1,5.06l3.54,1.26l1.3,1.42l0.35,3.16l2.72,0.32l0.65,0.75l0.04,8.02l-5.68,1.64l-1.31,1.49l0,0l-5.49,-1.85l-5.59,1.43l-1.43,-1.28l-4.5,0.72l-7.51,-1.99l-14.4,6.81l-4.07,-0.64l-0.97,-0.86l-2.15,1.58l-2.74,-0.74l-0.29,-2.03l-0.78,-0.15l-4.36,1.4l-1.29,-0.52l-2.34,1.73l-5.22,0.01l-1.35,-0.94l-2.77,3.33l-3.83,2.33l-0.74,2.68l-2.89,1.69l-1.92,0.12l-1.67,1.88l-5.02,-0.21l-2.93,4.61l-1.58,-0.77l-2.79,0.42l-3.47,-1.55l-2.69,-0.14l-1.87,-1.3l-2.52,0.83l-1.09,-1.43l-1.93,-0.52l-3.96,2.19l-1.09,-1.79l-0.89,0.4l-0.06,-0.8l-2.42,-1.08l-0.21,-1.72l-1.3,-0.81l0.67,-0.69l-0.88,-0.97l0.62,-3.8l-1.54,-0.17l-1.19,-1.54l-5.98,3.51l-1.37,-1.06l-5.34,1.65l-5.72,-0.11l-1.76,-2.72l-2.73,-1.98l-0.92,-2.06l-0.94,-9.55l-1.37,-1.01l-0.25,-1.41l-2.5,-0.39l-2.03,-1.38l-1.12,-1.91l-2.8,-0.44l-0.21,-2.11l0,0l-0.08,-1.11l2.17,-0.65l-1.97,-4.26l-1.4,1.5l0.56,-1.7l-0.95,-1.56l-1.24,-0.06l0.52,-2.62l1.62,0.38l-0.22,-2.27l1.54,0.63l-0.21,-2.52l0.67,-0.52l-0.76,-1.49l2.55,-2.94l1.13,0.45l1.06,-0.69l1,-4.27l0,0l2.02,0.23l6.56,3.24l0.98,-0.59l-0.6,1.57l1.36,0.85l0.67,-0.36l-0.51,-3.34L199.48,176.39z"
				},
				{
					"id":"HN-CH",
					"title":"Choluteca",
					"d":"M215,479.24l1.9,1l0.42,1.94l-1.53,2.1l-0.51,1.93l-0.79,0.04l-0.76,-3.49l1.05,-1.1L215,479.24zM215.44,440.79l-0.73,-1.76l1.66,-5.21l-0.71,-2.91l1.93,-0.79l4.54,1.29l2.21,-0.36l-1.48,2.75l-0.05,2.01l0.8,-0.12l1.04,2.07l1.81,0.6l0.23,1.61l5.38,-0.6l3.57,1.28l3.27,-1.01l4.82,2.24l0,0l-1.3,6.02l2.72,0.19l1.77,2.5l0.09,3.44l1.82,1.65l6.67,-0.67l-0.42,2.36l0.89,2.28l2.6,1.47l0.3,-1l1.59,1.01l1.78,-2.14l2.84,-0.37l0.12,-1.77l1.86,-1.39l0.37,-2.72l1.52,-1.18l1.89,-0.04l3.77,-3.6l1.07,-2.12l0.14,-3.02l0.78,1.25l4.03,-0.65l0.37,0.97l3.9,-1.86l1.28,-1.71l2.26,-0.11l1.53,0.88l1.74,-3.37l0.51,0.64l2.02,-0.51l0,0l-1.63,4.27l3.83,2.42l-1.92,7.34l1.96,1.21l0.61,1.39l0.96,8.44l1.74,5.15l-2.37,4.8l0.75,1.5l2.96,1.24l0.66,8.08l-4.1,3.37l-1.8,0.48l-7.18,-4.58l-1.09,0.1l-4.08,1.31l-1.4,2.25l-3.54,2.15l-0.36,4.01l-2.05,4.61l1.22,4.28l-1.71,2.84l1.7,3.7l-3.89,3.54l-0.9,3.29l-5.92,3.27l-1.09,-0.4l-1.09,2.25l-1.97,0.25l-2.04,-1.46l-2.12,-0.16l-25.51,1.25l-0.7,-1.14l2.03,-2.39l2.47,-1.03l-4.09,0.65l-3.9,-2.55l-2.66,-4.33l4.34,-2.29l-2.72,0.87l-0.25,-0.81l-3.86,-1.58l-4.21,0.45l-0.25,-5.82l-3.17,-6.89l0.95,-1.26l1.08,0.1l-0.13,-0.74l-1.65,0.45l-2.22,-2.81l-3.42,-1.78l-0.95,0.29l-0.09,-0.9l1.55,-2.72l1.81,-0.68l1.55,3.27l1.52,-0.16l2.09,-4.24l1.36,0.65l0.63,-0.71l-0.78,0.34l-1.63,-0.97l-0.47,-2.09l-1.14,-0.42v-1.58l3.74,0.45l1.65,-2.01l2.35,0.16l0.76,-2.4l0,0l0.57,-1.25l2.61,-0.61l1.53,-4.18l-2.92,-4.35l0.64,-4.87l-4.51,-2.78l-1.88,-4.99l-1.42,-0.55l1.82,-5.29l-4.68,-2.66L215.44,440.79z"
				},
				{
					"id":"HN-CL",
					"title":"Colón",
					"d":"M382.61,164.53l14.51,2.26l10.11,2.62l2.79,0.92l2.31,2.1l1.55,-0.88l3.01,1.24l0.57,1.54l0.79,-0.56l7.6,4.81l14.32,5.66l3.99,0.13l6.18,-2.16l9.06,0.23l10.26,-1.41l6.46,-2.46l6.34,-5.37l6.08,-3.31l2.47,-0.46l5.82,0.85l0,0l0.01,107.99l0,0l-11.44,-13.14l-15.63,-3.88l-16.13,-22.29l-16.03,-5.87l-9.49,-9.1l-12.44,-6.19l-2.89,1.81l-1.35,-0.26l-2.04,-1.99l-2.51,1.02l-0.02,2.37l-2.87,1.06l-2.56,3.24l-3.14,-0.64l-0.59,-0.88l-2.21,0.19l-0.9,0.95l0.56,2.34l-4.75,4.71l-1.87,0.31l-2.02,2.28l-0.43,1.89l-4.85,2.7l-1.4,-0.23l-0.81,1.4l-1.38,0.27l-1.07,-1.24l-4.1,-0.46l-0.49,1.43l-1.33,-0.57l-2.67,1.99l-2.78,0.53l-1.83,-0.39l-7.54,-4.63l0,0l0.09,-3.5l-1.05,-1.32l1.47,-1.31l-0.58,-1.47l0.85,-3.28l-1.34,-2.52l0.93,-0.75l-2.51,0.19l-0.16,1.08l-3.22,-2.17l-4.76,-0.95l-8.38,1.39l-4.32,-3.55l-2.52,-0.75l0,0l1.31,-1.49l5.69,-1.63l-0.04,-8.02l-0.65,-0.75l-2.72,-0.32l-0.34,-3.16l-1.3,-1.42l-3.54,-1.26l-1,-5.06l1,-0.95l-3.64,-2.33l-1.27,-1.9l0,0l2.25,-0.23l9,4.45l2.15,-0.98l4.05,0.66l3.01,-2.49l5.39,-1.31l7.22,-6.84l2.38,-1.21l4.78,-0.88l4.09,-1.9l6.49,0.89l8.74,-0.89l5.7,-2.55l4.43,-3.93l3.39,2.59l2.57,-0.72l1.84,-3.11l1.87,-0.29l-0.22,-1.28l-4.37,-1.7l-2.37,-0.1l-1.58,1.64l0.54,1.15l-3.94,3.27l1.15,-4.05l-0.95,-2.69l-2.06,-0.75l-5.1,0.75l-3.26,-2.1L382.61,164.53z"
				},
				{
					"id":"HN-CM",
					"title":"Comayagua",
					"d":"M183.32,284.94L187.69,285.08L191.19,283.55L193.48,284.22L194.96,283.71L196.7,285.19L197.89,283.64L200.68,283.2L200.15,281.76L201.83,281.76L202.97,280.16L205.19,279.72L208.93,283.5L209.12,287.31L209.96,288.79L212.05,289.47L211.82,290.5L213.21,290.43L213.04,293.4L214.23,294.58L213.59,295.6L214.43,297.91L217.03,298.54L219.57,298L222.6,294.67L224.53,294.29L226.22,295.51L229.63,295.32L231.23,297.38L232.42,295.91L233.86,295.86L235.32,298.05L240.47,300.27L240.64,300.98L240.64,300.98L239.85,301.86L241.35,303.01L241.16,304.47L237.46,304.82L235.49,307.26L235.21,308.81L237.01,311.7L237.26,315.25L236.45,318.61L235.14,318.76L234.81,320.87L235.4,321.7L232.71,322.58L232.87,323.23L231.19,324.46L229.95,324.46L230.27,326.29L228.68,325.7L229.11,328.29L227.78,332.82L225.38,332.88L224.46,331.7L219.95,331.54L219.74,336.84L212.88,343.16L214.7,348.5L216.29,348.8L219.01,351.13L220.5,351.19L220.49,353.33L218.66,354.53L221.27,354.96L222.56,356.82L220.3,362.96L216.38,364.28L213.07,369.47L214.19,372.36L219.69,375.09L218.41,375.82L218.85,377.25L214.01,378.88L212.34,382.78L205.12,387.55L200.88,386.81L199.78,387.39L196.72,391.13L196.74,393.78L196.74,393.78L192.92,393.8L189.01,398.32L188.53,396.07L189.25,394.16L188.1,391.58L186.32,392.72L183.73,388.48L178.67,387.7L178.66,385.91L180.42,384.8L178.47,381.68L174.45,380.53L173.55,377.9L175.23,376.49L175.37,377.14L179.18,375.42L179.77,376.44L183.36,376.16L184.03,375.07L187.81,374.48L189.83,372.72L191.16,373.6L191.79,372.51L192.43,372.9L192.69,372.28L193.2,373.03L194.45,372.33L194.14,371.04L194.91,371.33L195.82,370.44L194.73,368.17L195.69,367.12L194.56,366.64L194.86,363.66L193.4,361.31L193.65,360.01L187.7,363L181.99,360.34L178.97,360.14L178.2,358.02L173.37,357.76L171.33,354.01L171.33,354.01L172.31,353.23L171.82,351.46L167.54,346.01L166.16,345.27L165.83,341.59L161.44,340.17L159.38,332.26L156.7,332.2L155.67,331.01L149.66,329.35L147.5,329.69L145.68,326.82L145.68,326.82L148.32,324.53L144.93,320.3L149.23,315.51L151.55,314.55L155.27,310.66L155.27,310.66L156.77,310.6L166.39,303.68L170.85,299.81L172.16,297.71L173.8,297.63L175.27,296.18L175.85,296.6L176.98,294.46L178.58,294.92L179.22,292.94L182.5,291.94L184.15,288.99L183.04,287.2z"
				},
				{
					"id":"HN-CP",
					"title":"Copán",
					"d":"M67.27,251.52L73.54,258.14L72.27,261.26L75.94,264.11L77.24,267.04L80.84,268.75L79.48,269.65L78.95,273.38L81.2,275.62L82.02,278.6L79.92,279.45L77.74,281.73L77.15,287.32L74.6,292.93L76.16,296.48L80.83,295.55L81.58,296.04L81.25,296.87L81.25,296.87L81.97,299.19L80.74,301.11L81.45,303.18L80.32,303.09L80.36,305.56L78.39,306.84L77.11,312.48L78.64,313.49L79.61,316.59L79.06,317.52L80.37,319.21L80.31,320.44L77.14,319.85L75.99,321.1L71.22,321.64L64.71,320.18L63.49,322.09L66.28,328L68.76,329L71.03,332.74L68.2,334.72L65.97,339.91L65.97,339.91L61.78,341.88L59.48,341.7L60.27,345.59L57.83,346.25L57,344.48L52.33,343.62L49.98,340.92L50.34,339.1L48.17,338.43L48.83,338.04L49.44,334.33L40.98,327.31L39.2,320.51L32.83,320.2L30.96,319L24.73,320.92L24.73,320.92L25.55,318.86L21.76,316.8L21.37,311.61L15.06,304.25L14.66,301.23L15.04,298.72L18.53,296.81L21.67,291.63L22.7,287.27L19.42,284.9L22.39,277.8L43.75,269.38L59.83,255.5z"
				},
				{
					"id":"HN-CR",
					"title":"Cortés",
					"d":"M184.76,177.27l-1,4.27l-1.06,0.69l-1.13,-0.45l-2.55,2.94l0.76,1.49l-0.67,0.52l0.21,2.52l-1.53,-0.63l0.22,2.27l-1.61,-0.38l-0.52,2.63l1.24,0.06l0.95,1.56l-0.56,1.7l1.4,-1.5l1.97,4.26l-2.16,0.65l0.08,1.11l0,0l-0.99,1.38l-2.19,-1.69l-0.45,2.22l-2.24,0.88l-1.38,1.71l3.53,-0.6l0,0.85l-1.96,0.48l-0.36,2.53l0.99,0.57l1.42,-1.29l-0.3,2.46l1.2,0.66l2.6,-0.28l0.05,2.41l1.1,1.13l-0.07,2.05l-2.04,0.04l1.11,3l-2.34,-1.49l-1.14,0.33l0.73,2.3l-1.86,1.41l1.07,3.35l-1.97,-1.09l-0.81,0.31l0.55,1.45l-0.95,1.8l1.44,1.04l-0.49,1.79l1.88,0.79l0.2,1.7l-1.68,2.19l-1.15,-2.37l-3.25,0.62l4.46,2.62l0.55,3.33l-2.12,0.03l-0.98,3.33l-3.36,2.98l1.59,0.88l-0.19,0.81l-1.94,-0.97l-1.08,2.62l-2.48,-0.04l1.19,2.2l-1.81,0.09l-0.52,1.2l1.85,0.72l-0.16,1.35l-2.37,0.27l-0.37,2.49l0.35,2.02l1.52,-1.01l-0.06,5.01l2.8,1.14l3.49,-0.28l0.75,1.52l1.25,0.49l0.13,1.58l2.92,-0.25l0.7,1.1l1.32,-0.64l0.74,0.94l-0.28,1.15l1.87,0.32l1.28,-0.81l4.1,3.53l-0.73,1.18l0.69,2l-1.29,1.18l-0.49,3.1l1.74,3.41l-0.72,0.76l0,0l0,0l0,0l-0.28,2.26l1.1,1.79l-1.65,2.95l-3.27,1l-0.64,1.98l-1.6,-0.46l-1.13,2.14l-0.58,-0.42l-1.46,1.46l-1.65,0.08l-1.31,2.1l-4.45,3.87l-9.62,6.92l-1.5,0.06l0,0l-1.31,-3.35l1.04,-6.12l-1.17,-0.96l-2.24,-0.16l0.66,-0.86l-0.96,-1.3l0.21,-1.06l-1.07,0.45l1.3,-2.81l-3.58,1.01l3.51,-16.16l-1.56,-1.77l-5.06,-1.27l-4.05,-4.7l4.29,-5.09l2.04,-4.53l-4.57,-0.59l-1.09,-3.69l-1.55,-1.83l-0.84,-12.79l-1.82,-0.75l-1.98,0.69l-2.45,-1.54l-0.97,-1.58l-4.22,-1.33l-1.47,-3.67l0.69,-6.57l-22.56,-6.51l0,0l9.07,-7.31l2.98,-3.67l1.28,-2.2l-0.15,-1.85l1.24,-1.14l0.85,1.04l6.59,-2.43l0.5,-2.42l-0.77,-1.05l2.86,-0.25l6.81,4.61l4.37,-0.36l2.19,-2.29v-1.08l-0.7,-0.2l1.05,-1.63l1.62,-0.26l1.08,-1.86l3.23,-1.8v-2.19l5.54,-0.46l2.69,-1.93l2.57,-0.36l3.33,-3.37l0.76,0.62l1.24,-0.42l1.43,-2.72l-0.85,0.59l0.25,-0.98l-1.65,0.13l-1.99,2l-0.1,0.93l-0.53,-0.79l-3.04,-0.42l1.14,-2.36l5.48,0.07l4.02,-3.04l3.1,-0.23l1.17,-0.92l8.62,0.56l1.24,-0.43L184.76,177.27z"
				},
				{
					"id":"HN-EP",
					"title":"El Paraíso",
					"d":"M299.2,354.37L304.05,355.84L305.58,357.09L306.56,355.86L308.64,356.03L310.45,357.82L311.14,360.03L312.39,359.1L320.91,361L323.31,364.2L327.54,364.58L329.42,366.69L330.24,369.63L341.48,370.09L350.71,363.9L355.48,362.56L361.72,362.12L365.71,371.51L374.06,373.74L374.19,371.75L375.09,370.99L378.6,371.84L383.44,381.92L387.92,383.01L390.49,386.92L391.92,387.81L394.54,387.81L396.26,383.25L400.38,381.31L403.42,383.45L405.54,383.9L408.26,379.74L410.55,381.11L413.95,380.36L418.9,382.06L419.73,382.02L420.79,380.12L422.75,382.84L424.69,383.69L426.65,387.09L425.42,389.51L425.72,391L429.78,393.21L430.6,395.19L430.6,395.19L429.75,397.18L428.27,397.51L426.83,399.55L424.06,401.2L420.71,401.03L420.03,403.66L418.32,405.04L414.9,403.91L412.55,406.07L409.58,407.38L409.73,412.67L408.89,416.34L411.4,418.05L411.9,419.53L411.35,421.21L410,422.14L408.24,420.65L405.93,421.28L402.85,420.82L399.85,416.85L399.93,413.82L399.08,412.64L394.9,411.61L393.4,414.2L391.23,413.27L388.09,409.66L380.35,403.71L379.46,401.63L379.71,399.83L381.56,395.59L381.14,393.73L380.08,393.58L378.2,394.48L371.58,395.05L364.96,398.72L364.8,400.12L366.62,401.52L366.44,402.41L364.02,404.12L360.63,404.92L360.92,407.75L356.78,410.99L353.37,416.04L350.67,417.82L350.17,419.4L347.86,420.56L347.76,424.23L345.47,428.06L342.64,430.32L340.53,430.4L339.21,429.39L337.18,430.64L332.76,430.68L330.67,427.86L328.06,429.21L325.2,429.45L323.21,428.62L320.59,425.87L318.16,425.78L316.3,427.19L308.94,428.36L300.54,427.37L297.55,428.87L295.12,429L294.51,431.71L295.23,435.1L294.22,438.3L294.22,438.3L292.2,438.81L291.68,438.18L289.95,441.54L288.42,440.67L286.16,440.78L284.88,442.49L280.98,444.35L280.61,443.38L276.58,444.03L275.8,442.78L275.65,445.8L274.58,447.92L270.81,451.51L268.92,451.55L267.41,452.73L267.04,455.45L265.19,456.84L265.06,458.61L262.23,458.98L260.45,461.13L258.86,460.11L258.56,461.12L255.96,459.65L255.07,457.37L255.49,455.01L248.81,455.68L247,454.03L246.9,450.59L245.14,448.09L242.42,447.9L243.72,441.88L243.72,441.88L246.82,439.81L253.81,443.48L252.98,441.35L254.79,438.22L256.5,437.11L253.21,432.32L253.3,427.04L254.09,426.85L254.05,425.84L255.84,426.22L258.82,429.38L263.73,429.85L265.95,428.23L268.21,424.38L268.84,421.31L268.24,419.92L269.14,416.79L267.96,414.02L269.74,411.33L268.65,407.91L269.18,407.42L273.24,409.31L277.14,404.98L276.58,403.66L277.57,403.59L277.6,397.82L273.6,396.34L273.32,393.79L270.68,392.07L268.72,389.12L270.25,387.1L277.08,388.5L278.96,385.03L275.27,383.38L275.86,382.09L278.51,380.3L278.01,379.21L278.7,378.63L278.71,376.51L282.71,373.19L284.8,369.55L286.31,369.58L286.06,364.95z"
				},
				{
					"id":"HN-FM",
					"title":"Francisco Morazán",
					"d":"M240.64,300.98L242.35,301.67L243.05,300.05L242.73,298.11L240.77,297.63L241.16,296.19L239.95,294.14L243.85,290.67L243.65,286.06L245.14,284.26L249.08,283.8L249.54,283.11L252.54,283.25L255.72,285.12L261.87,283.92L266.53,284.98L266.53,284.98L269.51,289.73L272.94,290.59L273.36,292.07L276.69,293.67L275.71,294.14L273.1,298.58L273.56,301.68L275.19,302.67L276.5,305.74L276.23,309.13L278.41,310.28L277.32,313.68L279.95,316.52L282.8,325.47L286.46,328.82L289.17,328.83L290.01,330.81L293.15,332.73L294.15,335.05L296,336.17L295.06,341.61L295.87,344.11L297.3,344.52L296.87,347.59L299.5,352.96L299.2,354.37L299.2,354.37L286.06,364.95L286.31,369.58L284.8,369.55L282.71,373.19L278.71,376.51L278.7,378.63L278.01,379.21L278.51,380.3L275.86,382.09L275.27,383.38L278.96,385.03L277.08,388.5L270.25,387.1L268.72,389.12L270.68,392.07L273.32,393.79L273.6,396.34L277.6,397.82L277.57,403.59L276.58,403.66L277.14,404.98L273.24,409.31L269.18,407.42L268.65,407.91L269.74,411.33L267.96,414.02L269.14,416.79L268.24,419.92L268.84,421.31L268.21,424.38L265.95,428.23L263.73,429.85L258.82,429.38L255.84,426.22L254.05,425.84L254.09,426.85L253.3,427.04L253.21,432.32L256.5,437.11L254.79,438.22L252.98,441.35L253.81,443.48L246.82,439.81L243.72,441.88L243.72,441.88L238.9,439.64L235.63,440.65L232.06,439.37L226.68,439.97L226.46,438.36L224.65,437.76L223.6,435.68L222.8,435.8L222.86,433.79L224.33,431.04L222.13,431.41L217.59,430.12L215.66,430.91L216.37,433.82L214.71,439.03L215.44,440.79L215.44,440.79L208.68,438.3L205.47,435.15L200.95,435.6L195.74,432.49L193.38,432.98L193.9,423.19L193.9,423.19L196.92,418.57L196.81,416.46L198.32,415.37L199.36,407.88L198.72,406.94L199.32,405.81L197.88,403.66L196.74,393.78L196.74,393.78L196.72,391.13L199.78,387.39L200.88,386.81L205.12,387.55L212.34,382.78L214.01,378.88L218.85,377.25L218.41,375.82L219.69,375.09L214.19,372.36L213.07,369.47L216.38,364.28L220.3,362.96L222.56,356.82L221.27,354.96L218.66,354.53L220.49,353.33L220.5,351.19L219.01,351.13L216.29,348.8L214.7,348.5L212.88,343.16L219.74,336.84L219.95,331.54L224.46,331.7L225.38,332.88L227.78,332.82L229.11,328.29L228.68,325.7L230.27,326.29L229.95,324.46L231.19,324.46L232.87,323.23L232.71,322.58L235.4,321.7L234.81,320.87L235.14,318.76L236.45,318.61L237.26,315.25L237.01,311.7L235.21,308.81L235.49,307.26L237.46,304.82L241.16,304.47L241.35,303.01L239.85,301.86z"
				},
				{
					"id":"HN-GD",
					"title":"Gracias a Dios",
					"d":"M601.13,228.66l2.81,1.26l2.03,6.56l-1.42,1.54l-1.17,-5.42l-2.76,-2.87L601.13,228.66zM496.9,170.27l24.11,9.52l14.16,3.67l0.86,0.72l-1.43,1.15l-0.95,5.07l0.95,2.39l1.9,1.67l3.55,-1.37l-0.57,-2.32l0.54,-1.18l2.12,1.7l1.27,2.42l2.76,-0.2l0.98,0.29l2.5,-0.36l-1.04,-1.21l1.65,-2.06l0.7,0.49l-0.82,0.95h1.17l0.32,-1.11l1.11,0.26l0.1,-1.86l-1.43,-0.26l-1.43,-1.57l-13.49,-3.3l21.98,4.58l16.6,1.01l24.39,20.08l23.28,21.24l9.63,5.94l8.9,2.68l-1.42,2.19L637.92,242L632,237.01l-2.88,-1.47l-5.61,-1.89l-4.62,-0.2l-1.46,-1.37l1.52,0.29l-0.66,-2.42l-3.42,-2.48l-0.44,-1.5l-0.54,1.54l-1.27,0.16l0.51,-0.59l-7.54,-3.43l-3.42,4.02l-0.03,1.21l-1.36,-0.75l-1.46,1.7l-2.76,-0.16l1.96,4.61l-1.52,1.31l-1.11,-0.72l-1.3,0.72l1.43,1.73l-0.22,0.72l-1.52,-0.16l0.13,1.11l4.37,6.46l2.41,1.01l2.88,-0.2l-0.13,0.65l1.96,0.82l0.89,-0.72v-1.6l-2.34,-4.18l0.19,-1.44l2.79,-0.65l0.32,-0.95l6.02,0.98l6.27,4.73l2,0.65l2.15,2.42l1.9,1.01l3.26,0.2l0.98,1.7l2.6,1.44l-0.35,1.14l-2.44,1.7l2.38,-0.03l1.33,-0.75l0.35,-1.21l0.79,0.33l1.93,2.84l-1.3,3.2l1.17,2.58l-0.76,0.59l0.44,1.04l0.67,-1.44l0.28,0.98l0.95,-0.06l-0.35,-1.21l3.04,1.4l1.74,-0.78l0.67,-3.62l6.37,-3.2l0.79,-1.44l-0.38,-1.99l1.87,-1.63l0.03,1.53l4.78,-0.23l0.22,1.21l2.63,-0.56l1.49,0.88l0.35,-1.44l-2.44,-0.1l-0.06,-1.47l-1.87,0.1l-1.11,-1.24l-3.45,1.8l-0.28,-1.01l-2.25,-0.62l-0.79,-1.17l-0.76,1.18l-0.95,-2.09l-2.06,-1.21l-5.32,-1.57l0,-1.96l2.44,-2.87l3.36,3.14l7.67,4.18l17.36,5.55l8.65,3.69l4.02,6.04l3.39,9.82l3.8,5.45l7.76,5.35l7.41,2.48l2.44,-0.03v0.91l1.11,0.03l-0.66,1.14l-1.76,-0.6l-2.22,0.65l-4.66,-0.38l-3.16,1.46l-4.26,-0.38l-1.08,1.13l-1.01,-0.71l1.51,-1.32l-0.18,-0.89l-2.54,0.5l-4.74,-1.89l-1.23,1.73l-1.24,-1.69l-4.37,-1.81l-0.16,2.19l-2.12,2.17l-4.93,1.61l-1.81,-1.4l0.03,-1.52l-1.64,-0.34l-2.24,2.66l-1.59,-0.71l0.69,2.26l-1.82,-0.81l-0.39,1.41l1.11,2.08l-1.96,-0.35l0.84,1.43l-2.02,0.42l-0.28,3.06L656.06,296l-0.56,0.63l0.44,1.01l-2.35,0.69l0.53,1.15l-1.13,1.54l0.35,1.24l-1.05,-0.38l-0.34,-1.52l-1.55,-0.26l-4.83,1.7l-1.27,-0.66l0.11,1.51l-2.03,1.16l1.64,0.67l-0.21,1.42l-3.83,-0.66l0.34,1.84l-2.41,-0.91l-0.73,2.5l-2.49,-1.46l-1.13,1.95l-2.78,-0.69l2.3,2.19l-4.12,0.16l-1.82,1.98l-2.94,0.59l-0.52,-1.88l-0.82,-0.24l-0.08,2.06l-1.06,0.4l-2.17,-1.54l-2.11,0.47l0.5,2.98l-2.59,-0.91l-2.9,1.23l-2.63,-1.09l-2.72,1.28l-1.87,-0.49l-0.55,-2.57l-3.86,1.31l-0.54,-3.35l-3.02,-0.23l-0.53,1.59l2.17,3.82l0.08,1.79l-3.47,-0.42l-1.99,1.43l-3.85,0.67l-5.54,-2.74l0.72,-2l-1.86,-0.71l-3.29,2.6l0.95,4.04l-0.35,1.87l0.9,0.84l-2.78,2.29l-2,-0.62l-1.47,-2.49l-1.98,1.25l-2.46,-0.58l-0.3,-1.15l0.9,-1.86l-2.45,-1.18l-2.12,4.04l-2.88,2.75l-0.18,1.23l-2.64,1.34l-2.81,0.19l-1.3,1.84l-3.3,-0.76l-1.47,-1.57l-2.67,0.68l-0.28,-1.5l1.41,-1.44l-4.1,0.88l-1,-0.84l-1.43,0.39l-0.96,-0.88l-4.83,-0.52l-0.55,-1.21l-2.52,0.53l-2.44,-2.25l-1.69,3.05l-1.05,-0.09l-0.82,-3.16l-3.94,-2.68l-0.25,-3.87l-1.36,0.66l-1.19,-0.95l1.7,-0.5l0.21,-1.76l-3.16,-2.03l-1.2,-3.02l-3.06,-1.62l-4.6,1.9l-4.94,-0.08l-2.91,5.84l-3.71,0.78l-3.93,3.12l0,0l0.22,-39.46l0,0l-0.01,-107.99l0,0L496.9,170.27z"
				},
				{
					"id":"HN-IN",
					"title":"Intibucá",
					"d":"M145.68,326.82L147.5,329.69L149.66,329.35L155.67,331.01L156.7,332.2L159.38,332.26L161.44,340.17L165.83,341.59L166.16,345.27L167.54,346.01L171.82,351.46L172.31,353.23L171.33,354.01L171.33,354.01L164.45,359.38L159.72,358.53L159.99,360.39L159.05,361.32L160.41,364.19L160.09,366.06L157.98,366.81L157.12,370.13L154.35,371.12L153.62,374.82L149.03,374.71L147.34,375.59L142.29,379.62L142.21,381.76L140.77,384.04L136.5,385.73L133.65,388.07L128.94,394.39L127.53,394.21L128.41,396.22L131.09,398.17L129.9,404.68L129.9,404.68L129.48,410.61L124.96,414.5L113.76,418.24L111.06,416.25L105.21,417L103.97,418.66L101.19,418.6L100.84,419.99L97.62,418.97L97.49,416.68L95.64,412.94L96.13,409.59L96.13,409.59L97.38,409.49L97.28,408.16L98.06,408.37L98.53,407.07L99.83,406.55L99.43,405.04L100.76,404.71L101.43,403.22L103.45,403.04L104.23,402.07L110.45,399.72L112.68,398.04L114.25,395.56L116.73,395.35L116.39,393.1L118.35,391.6L117.54,388.39L117.98,385.95L116.93,385.02L117.96,379.22L116.54,377.63L110.6,377.27L106.51,375.18L106.21,373.71L107.82,370.93L105.98,361.75L104.86,361.2L102.78,361.64L97.67,356.69L98.2,356.15L97.86,350.78L103.11,348.19L105.47,348.87L111.17,348.53L115.16,345.26L114.9,342.24L117.71,337.96L116.99,331.84L114.96,328.04L115.42,327.72L115.42,327.72L125.97,328.75L128.39,327.63L136.61,327.18L143.33,328.94z"
				},
				{
					"id":"HN-IB",
					"title":"Islas de la Bahía",
					"d":"M325.21,171.84l0.38,1.08l-0.63,0.59l-0.73,-0.52L325.21,171.84zM327.74,170l0.95,0.62l-0.79,1.51l-1.24,-1.31L327.74,170zM280.73,153.23l1.9,0.79l-1.87,3.57l-0.82,-1.15l-0.98,0.26l-5.83,3.01l-3.9,-1.47l1.04,-2.26l4.18,-0.85l0.86,-1.57l2.92,0.72L280.73,153.23zM350.55,116.93l5.99,0.82l3.07,-0.66l0.86,0.92l-1.55,-0.2l-2.57,1.84l-1.42,-1.44l-3.36,0.1l-0.7,1.02l-2.44,-0.43l-0.41,0.92l-2,0.33l-1.36,1.41l-1.55,-0.36l-2.34,1.02l-1.93,-0.56l0.54,1.08l-0.82,0.49l-0.63,-0.72l-0.51,2.13l-0.76,-0.56l-1.62,0.33l-0.06,0.85l-2.44,-0.23l-5.8,3.22l0.06,1.41l-1.3,0.23l-0.09,-1.02l-3.86,2.17l-2.28,-0.13l-5.83,5.45l0.95,-5.21l5.45,-4.03l2.53,-1.25l1.43,0.3l1.84,-1.54l1.14,0.2l2.85,-1.67l2.31,0.1l4.75,-3.22l0.51,0.43l6.02,-2.4L350.55,116.93zM365.79,115.02l2.38,0.43l-2.12,1.67l-1.08,-0.69l-2,0.79l1.04,-1.54L365.79,115.02zM398.57,106.81l2.82,1.64l0.98,-0.69l0.48,1.94l-3.23,1.05l-0.1,1.81l-1.52,1.9l-1.36,-0.62l-3.52,1.81l0.7,0.53l-6.15,4.23l2.31,-6.1l1.77,0.2l0.92,-3.48l0.82,-0.03l1.74,-2.49l1.87,0.43l0.13,-1.21L398.57,106.81z"
				},
				{
					"id":"HN-LP",
					"title":"La Paz",
					"d":"M171.33,354.01L173.37,357.76L178.2,358.02L178.97,360.14L181.99,360.34L187.7,363L193.65,360.01L193.4,361.31L194.86,363.66L194.56,366.64L195.69,367.12L194.73,368.17L195.82,370.44L194.91,371.33L194.14,371.04L194.45,372.33L193.2,373.03L192.69,372.28L192.43,372.9L191.79,372.51L191.16,373.6L189.83,372.72L187.81,374.48L184.03,375.07L183.36,376.16L179.77,376.44L179.18,375.42L175.37,377.14L175.23,376.49L173.55,377.9L174.45,380.53L178.47,381.68L180.42,384.8L178.66,385.91L178.67,387.7L183.73,388.48L186.32,392.72L188.1,391.58L189.25,394.16L188.53,396.07L189.01,398.32L192.92,393.8L196.74,393.78L196.74,393.78L197.88,403.66L199.32,405.81L198.72,406.94L199.36,407.88L198.32,415.37L196.81,416.46L196.92,418.57L193.9,423.19L193.9,423.19L191.22,423.18L188.56,420.84L183.09,421.88L183.09,421.88L182.51,419.03L176.86,415.46L173.48,416.07L167.37,414.27L164.6,414.32L162.08,415.77L158.77,414.48L152.81,417.89L152.26,415.78L146.35,407.3L146.31,405.04L142.08,404.11L135.94,406.01L131.95,404.34L129.9,404.68L129.9,404.68L131.09,398.17L128.41,396.22L127.53,394.21L128.94,394.39L133.65,388.07L136.5,385.73L140.77,384.04L142.21,381.76L142.29,379.62L147.34,375.59L149.03,374.71L153.62,374.82L154.35,371.12L157.12,370.13L157.98,366.81L160.09,366.06L160.41,364.19L159.05,361.32L159.99,360.39L159.72,358.53L164.45,359.38z"
				},
				{
					"id":"HN-LE",
					"title":"Lempira",
					"d":"M81.25,296.87L84,297.05L85.15,295.96L85.42,293.71L91.56,295.23L94.12,302.51L99.07,309.62L101.12,308.83L102.79,304.84L104.18,304.12L107.04,305.12L107.93,306.69L111.67,306.54L113.41,308.18L110.53,314.4L112.39,318.38L114.51,320.14L118.75,318.41L118.39,324.14L115.42,327.72L115.42,327.72L114.96,328.04L116.99,331.84L117.71,337.96L114.9,342.24L115.16,345.26L111.17,348.53L105.47,348.87L103.11,348.19L97.86,350.78L98.2,356.15L97.67,356.69L102.78,361.64L104.86,361.2L105.98,361.75L107.82,370.93L106.21,373.71L106.51,375.18L110.6,377.27L116.54,377.63L117.96,379.22L116.93,385.02L117.98,385.95L117.54,388.39L118.35,391.6L116.39,393.1L116.73,395.35L114.25,395.56L112.68,398.04L110.45,399.72L104.23,402.07L103.45,403.04L101.43,403.22L100.76,404.71L99.43,405.04L99.83,406.55L98.53,407.07L98.06,408.37L97.28,408.16L97.38,409.49L96.13,409.59L96.13,409.59L97.27,406.96L94.26,404.72L89.61,404.99L86.86,401.74L84.76,402.11L82.37,400.29L76.35,401.22L68.32,392.6L60.91,393.05L55.44,381.69L51.59,380.06L50.45,378.72L45.01,378.82L43.83,377.9L43.83,377.9L43.57,373.71L44.36,372.06L42.66,368.7L45.58,367.32L46.63,363.98L51.06,363.46L53.44,362.35L54.59,360.3L54.66,356.23L56.84,356.59L57.12,357.63L59.26,359.13L62.75,359.05L60.54,356.94L61.26,354.07L63.95,355.71L70.67,352.64L70.4,350.91L71.13,350.38L70.96,348.74L72.88,344.31L73.13,341.62L72.1,340.57L68.78,340.93L65.97,339.91L65.97,339.91L68.2,334.72L71.03,332.74L68.76,329L66.28,328L63.49,322.09L64.71,320.18L71.22,321.64L75.99,321.1L77.14,319.85L80.31,320.44L80.37,319.21L79.06,317.52L79.61,316.59L78.64,313.49L77.11,312.48L78.39,306.84L80.36,305.56L80.32,303.09L81.45,303.18L80.74,301.11L81.97,299.19z"
				},
				{
					"id":"HN-OC",
					"title":"Ocotepeque",
					"d":"M24.73,320.92L30.96,319L32.83,320.2L39.2,320.51L40.98,327.31L49.44,334.33L48.83,338.04L48.17,338.43L50.34,339.1L49.98,340.92L52.33,343.62L57,344.48L57.83,346.25L60.27,345.59L59.48,341.7L61.78,341.88L65.97,339.91L65.97,339.91L68.78,340.93L72.1,340.57L73.13,341.62L72.88,344.31L70.96,348.74L71.13,350.38L70.4,350.91L70.67,352.64L63.95,355.71L61.26,354.07L60.54,356.94L62.75,359.05L59.26,359.13L57.12,357.63L56.84,356.59L54.66,356.23L54.59,360.3L53.44,362.35L51.06,363.46L46.63,363.98L45.58,367.32L42.66,368.7L44.36,372.06L43.57,373.71L43.83,377.9L43.83,377.9L42.75,377.65L42.93,376.19L41.12,373.22L36.89,370.52L37.01,366.41L35.07,364.27L29.7,362.05L24.48,363.14L20.89,362.77L15.2,358.59L5.99,356.9L0.12,353.12L0.26,348.04L6.21,344.72L6,343.48L8.01,341.98L8.84,339.74L12.62,335.14L15.19,334.26L19.74,335.76L22.28,335.6L23.32,332.06L22.56,324.99z"
				},
				{
					"id":"HN-OL",
					"title":"Olancho",
					"d":"M355.79,237.01L363.33,241.64L365.16,242.03L367.94,241.5L370.61,239.51L371.94,240.08L372.43,238.66L376.53,239.12L377.6,240.35L378.98,240.08L379.79,238.68L381.2,238.91L386.05,236.22L386.48,234.32L388.51,232.04L390.37,231.73L395.13,227.02L394.57,224.69L395.47,223.74L397.68,223.54L398.27,224.43L401.41,225.06L403.97,221.82L406.83,220.76L406.85,218.4L409.36,217.38L411.41,219.37L412.76,219.63L415.65,217.82L428.1,224.01L437.59,233.11L453.62,238.97L469.76,261.26L485.39,265.14L496.83,278.28L496.83,278.28L496.62,317.75L496.62,317.75L492.94,320.87L493.49,322.46L492.52,324.26L491.21,324.13L490.23,325.33L493.16,328.73L491.33,331.07L493.28,332.12L491.01,335.59L488.3,337.71L485.93,338.3L481.71,334.68L478.93,336.27L480.12,338.43L480.3,342.58L478.97,345.31L475.82,348.62L472.58,356.98L470.44,359.65L472.9,360.85L473.2,363.2L474.45,364.5L475.5,364.19L475.82,366.77L478.15,368.22L475.22,373.24L474.25,373.52L473.67,372.47L464.4,372.43L462.32,373.44L459.96,372.76L457.53,373.93L455.39,377.53L454.2,377.35L453.89,376.24L452.86,376.48L453.41,378.12L452.89,382.01L450.53,384.29L450.89,386.61L447.31,390.12L445.67,390.34L444.15,389.42L442.57,391.79L441.58,391.65L441.24,393.07L439.97,391.6L439.71,393.4L438.54,392.42L436.51,397.1L432.7,396.89L432.14,394.9L430.6,395.19L430.6,395.19L429.78,393.21L425.72,391L425.42,389.51L426.65,387.09L424.69,383.69L422.75,382.84L420.79,380.12L419.73,382.02L418.9,382.06L413.95,380.36L410.55,381.11L408.26,379.74L405.54,383.9L403.42,383.45L400.38,381.31L396.26,383.25L394.54,387.81L391.92,387.81L390.49,386.92L387.92,383.01L383.44,381.92L378.6,371.84L375.09,370.99L374.19,371.75L374.06,373.74L365.71,371.51L361.72,362.12L355.48,362.56L350.71,363.9L341.48,370.09L330.24,369.63L329.42,366.69L327.54,364.58L323.31,364.2L320.91,361L312.39,359.1L311.14,360.03L310.45,357.82L308.64,356.03L306.56,355.86L305.58,357.09L304.05,355.84L299.2,354.37L299.2,354.37L299.5,352.96L296.87,347.59L297.3,344.52L295.87,344.11L295.06,341.61L296,336.17L294.15,335.05L293.15,332.73L290.01,330.81L289.17,328.83L286.46,328.82L282.8,325.47L279.95,316.52L277.32,313.68L278.41,310.28L276.23,309.13L276.5,305.74L275.19,302.67L273.56,301.68L273.1,298.58L275.71,294.14L276.69,293.67L273.36,292.07L272.94,290.59L269.51,289.73L266.53,284.98L266.53,284.98L269,281.67L274.1,281.94L274.72,278.67L278.99,277.14L279.16,272.55L281.02,270.82L281.28,269.77L280.56,269.4L281.63,267.74L280.07,259.35L280.48,257.37L285.68,254.68L286.01,253L288.68,253.86L290.72,251.68L292.3,252.57L293.23,254.71L299.13,255.33L303.21,253.13L303.35,252.05L304.98,250.78L305.25,246.88L307.04,246.27L308.68,246.88L310.75,245.05L316.15,243.04L319.55,240.48L321.43,241.04L324.08,239.75L324.27,238.61L328.41,239.7L329.83,242.74L332.14,242.84L334.37,248.2L335.58,248.39L349.88,240.96z"
				},
				{
					"id":"HN-SB",
					"title":"Santa Bárbara",
					"d":"M104.5,221.81L127.06,228.33L126.37,234.9L127.84,238.57L132.05,239.91L133.02,241.49L135.47,243.03L137.45,242.34L139.27,243.09L140.11,255.88L141.66,257.71L142.75,261.4L147.32,261.99L145.27,266.52L140.98,271.61L145.03,276.31L150.09,277.58L151.65,279.35L148.14,295.5L151.72,294.49L150.42,297.3L151.49,296.85L151.28,297.91L152.24,299.21L151.58,300.07L153.82,300.23L155,301.19L153.96,307.31L155.27,310.66L155.27,310.66L151.55,314.55L149.23,315.51L144.93,320.3L148.32,324.53L145.68,326.82L145.68,326.82L143.33,328.94L136.61,327.18L128.39,327.63L125.97,328.75L115.42,327.72L115.42,327.72L118.39,324.14L118.75,318.41L114.51,320.14L112.39,318.38L110.53,314.4L113.41,308.18L111.67,306.54L107.93,306.69L107.04,305.12L104.18,304.12L102.79,304.84L101.12,308.83L99.07,309.62L94.12,302.51L91.56,295.23L85.42,293.71L85.15,295.96L84,297.05L81.25,296.87L81.25,296.87L81.58,296.04L80.83,295.55L76.16,296.48L74.6,292.93L77.15,287.32L77.74,281.73L79.92,279.45L82.02,278.6L81.2,275.62L78.95,273.38L79.48,269.65L80.84,268.75L77.24,267.04L75.94,264.11L72.27,261.26L73.54,258.14L67.27,251.52L67.27,251.52L75.94,245.97L85.45,237.01L89.24,235.25z"
				},
				{
					"id":"HN-VA",
					"title":"Valle",
					"d":"M194.98,484.29l2.88,1.03l0.07,3.76l-2.06,1.03l-2.98,-0.26l-0.91,-3.2l0.84,-0.03l0.32,-1.78L194.98,484.29zM191.15,480.5l0.86,1.62l-1.39,1.59l-0.67,-1.23L191.15,480.5zM202.25,477.28l1.76,0.08l0.47,1.1l1.84,0.84l-3.77,0.81l0.1,-1.62l-1.09,-0.72L202.25,477.28zM199.96,474.84l2.5,0.5l0.56,0.92l1.05,0.29l-3.8,0.91l2.07,1.46l-0.52,4.3l-1.87,-0.55l-2.15,0.65l-3.39,-1.26l-1.58,-1.95l-0.13,-1.39l0.89,-0.42l-0.41,-1.81l0.92,0.42l1.43,-1.45l1.68,1.2L199.96,474.84zM215.54,472.08L215.31,473l0.86,0.45l0.83,-0.39l0.44,1.1l1.46,0.1l-1.17,1.26l-2.82,0.26L214,474.25l0.38,-1.56L215.54,472.08zM215.95,470.84l1.08,0.22l-0.67,1.1l1.82,0.3l0.81,1.29l-1.24,0.2l-0.48,-1.17l-1.52,0.15L215.95,470.84zM217.47,471.67l-0.13,-0.87l-1.49,-0.26l-0.6,1.26l-1.51,0.5l-0.2,5.2l-3.55,-2.17l0.7,-1.13l-1.55,0.81l0.35,1.03l1.04,0.12l0.29,1.24l-0.92,0.49l-0.25,-0.61l-0.76,1.26l-1.74,0.58l-2.79,-1.78l1.33,-1.52l-1.44,0.52l-1.36,-1.28l-3.14,-0.55l-2.17,0.83l1.08,-3.04l-2.53,-1.45l0.28,-0.71l0.98,0.19l-0.57,-2.01l1.24,-2.62l-0.44,-0.42l-0.85,-0.55l-3.52,1.52l-0.63,2.04l1.01,0.2l0.38,2.14l-1.43,1.46l0.32,1.65l-1.61,-0.16l-0.73,2.4l-1.64,-0.23l-0.04,0.71l-2.57,0.26l-0.13,0.78l-3.26,-0.03l-2.12,-2.17l-3.9,-1.07l-1.4,-2.1l1.9,-0.08l0.96,-1.46l1.47,-0.09l1.94,-1.8l3.56,-0.6l0.84,-2.65l-0.47,-4.52l-3.01,-0.38l-0.54,-0.86l-1.39,1.05l-1.85,-0.35l-1.07,-1.69l0.73,-0.92l-0.32,-2.97l0.79,-1l-0.63,-0.62l1.08,-0.4l2.28,-3.61l0.39,-10.06l2.32,-2.71l0.69,-1.81l-0.84,-1.94l2.66,-3.95l0.09,-4.05l-2.12,-0.81l-1.88,-1.92l0,0l5.47,-1.04l2.67,2.34l2.68,0.02l0,0l-0.52,9.78l2.36,-0.48l5.21,3.11l4.52,-0.45l3.2,3.15l6.77,2.48l0,0l0.72,1.51l4.68,2.66l-1.82,5.29l1.43,0.55l1.88,4.99l4.51,2.78l-0.63,4.87l2.92,4.35l-1.53,4.18l-2.61,0.61l-0.57,1.25l0,0l-1.1,2.09l-2.06,-0.23l-1.59,1.78l-0.32,-2.1l0.98,-3.33l1.33,0.71l2.03,-0.39l-1.68,-0.29l0.38,-1.46l-1.32,0.55l0.1,-1.16l-1.3,0.81l-0.7,2.14L217.47,471.67z"
				},
				{
					"id":"HN-YO",
					"title":"Yoro",
					"d":"M183.32,284.94L184.04,284.19L182.3,280.77L182.79,277.68L184.08,276.49L183.39,274.5L184.12,273.32L180.02,269.79L178.74,270.59L176.87,270.28L177.15,269.13L176.41,268.19L175.09,268.84L174.4,267.73L171.48,267.99L171.35,266.41L170.1,265.92L169.35,264.4L165.86,264.68L163.06,263.54L163.13,258.53L161.61,259.54L161.26,257.51L161.64,255.02L164,254.75L164.16,253.41L162.31,252.69L162.83,251.49L164.64,251.4L163.45,249.19L165.92,249.23L167.01,246.61L168.95,247.58L169.14,246.77L167.55,245.89L170.91,242.91L171.9,239.59L174.02,239.56L173.47,236.23L169.02,233.61L172.27,233L173.42,235.37L175.1,233.17L174.91,231.48L173.02,230.69L173.51,228.9L172.07,227.86L173.02,226.06L172.47,224.61L173.28,224.3L175.26,225.39L174.19,222.04L176.05,220.63L175.32,218.32L176.46,217.99L178.8,219.48L177.69,216.48L179.72,216.45L179.79,214.4L178.69,213.27L178.63,210.87L176.04,211.14L174.84,210.49L175.15,208.03L173.72,209.32L172.73,208.75L173.09,206.22L175.05,205.75L175.04,204.9L171.51,205.5L172.9,203.79L175.14,202.91L175.59,200.69L177.77,202.38L178.76,201L178.76,201L178.97,203.11L181.77,203.55L182.89,205.46L184.93,206.84L187.43,207.23L187.68,208.64L189.05,209.65L190,219.2L190.92,221.25L193.65,223.23L195.41,225.95L201.13,226.06L206.47,224.41L207.83,225.47L213.81,221.96L215.01,223.5L216.55,223.68L215.92,227.48L216.8,228.45L216.14,229.14L217.44,229.95L217.65,231.67L220.08,232.75L220.14,233.55L221.03,233.15L222.12,234.95L226.08,232.75L228.01,233.28L229.11,234.71L231.63,233.87L233.51,235.18L236.2,235.32L239.67,236.86L242.46,236.44L244.03,237.22L246.96,232.61L251.98,232.81L253.65,230.93L255.56,230.82L258.45,229.13L259.19,226.45L263.02,224.11L265.8,220.78L267.15,221.73L272.37,221.72L274.71,219.99L276,220.51L280.36,219.11L281.14,219.26L281.43,221.29L284.17,222.03L286.32,220.45L287.28,221.31L291.35,221.95L305.75,215.14L313.26,217.14L317.76,216.41L319.18,217.7L324.77,216.27L330.26,218.11L330.26,218.11L332.79,218.87L337.11,222.41L345.49,221.02L350.25,221.98L353.47,224.14L353.64,223.06L356.14,222.87L355.22,223.62L356.56,226.13L355.72,229.41L356.3,230.88L354.83,232.19L355.88,233.52L355.79,237.01L355.79,237.01L349.88,240.96L335.58,248.39L334.37,248.2L332.14,242.84L329.83,242.74L328.41,239.7L324.27,238.61L324.08,239.75L321.43,241.04L319.55,240.48L316.15,243.04L310.75,245.05L308.68,246.88L307.04,246.27L305.25,246.88L304.98,250.78L303.35,252.05L303.21,253.13L299.13,255.33L293.23,254.71L292.3,252.57L290.72,251.68L288.68,253.86L286.01,253L285.68,254.68L280.48,257.37L280.07,259.35L281.63,267.74L280.56,269.4L281.28,269.77L281.02,270.82L279.16,272.55L278.99,277.14L274.72,278.67L274.1,281.94L269,281.67L266.53,284.98L266.53,284.98L261.87,283.92L255.72,285.12L252.54,283.25L249.54,283.11L249.08,283.8L245.14,284.26L243.65,286.06L243.85,290.67L239.95,294.14L241.16,296.19L240.77,297.63L242.73,298.11L243.05,300.05L242.35,301.67L240.64,300.98L240.64,300.98L240.47,300.27L235.32,298.05L233.86,295.86L232.42,295.91L231.23,297.38L229.63,295.32L226.22,295.51L224.53,294.29L222.6,294.67L219.57,298L217.03,298.54L214.43,297.91L213.59,295.6L214.23,294.58L213.04,293.4L213.21,290.43L211.82,290.5L212.05,289.47L209.96,288.79L209.12,287.31L208.93,283.5L205.19,279.72L202.97,280.16L201.83,281.76L200.15,281.76L200.68,283.2L197.89,283.64L196.7,285.19L194.96,283.71L193.48,284.22L191.19,283.55L187.69,285.08z"
				}
			]
		}
	}
};