(function(){
    var AuctionItems = function() {

        return {

            init: function() {
                var dt = $('#datatable-auction').on('xhr.dt', function ( e, settings, json ) {

                    $('#searchBtn').prop('disabled', false);
    
                    } ).DataTable( {
                      
                            ajax: {
                                url: ajax_auction_dt,
                                type: 'POST',
                                data: function(d) {
                                    d.title = $('#title').val();
                                    d.category = $('#category').val();
                                    d.winner= $('#userID').val();
                                    d.startDate = $('#startDate').val();
                                    d.endDate = $('#endDate').val();
                                }
                            },
                            lengthMenu: [ 25, 50, 75, 100 ],
                            pageLength: 25,
                            serverSide: true,
                            retrieve: true,
                            paging: true,
                            searching: false,
                            "columns": [
                                { "title": "ID", "data": "id", "sortable": true },
                                { "title": "Title", "data": "title", "sortable": true },
                                { "title": "Category", "data": "category_name", "sortable": true },
                                { "title": "Current Price", "data": "current_price", "sortable": true },
                                { "title": "Buy Price", "data": "buy_price", "sortable": true },
                                { "title": "Status", "data": "status", "sortable": true },
                                { "title": "Ends", "data": "ends_at", "sortable": true },
                                { "title": "Winner", "data": "winner", "sortable": false },
                                { "title": "Actions", "data": null, "sortable": false }
                          
                        ],
                        "columnDefs": [
                            {
                                "targets": [8],
                                "render": function ( data, type, full, meta ) {
                                    if(full.status !== 'Inactive') {
                                        return '<a href="' + url_admin_auction_edit + '/' + full.id + '" class="btn btn-sm yellow" id="edit"><i class="fa fa-pencil"></i> Edit</a><button class="btn btn-sm red" id="remove" data-id="' + full.id + '"><i class="fa fa-close"></i> Delete</button>';
                                    }
                                    else{
                                        return '<a href="' + url_admin_auction_edit + '/' + full.id + '" class="btn btn-sm yellow" id="edit"><i class="fa fa-pencil"></i> Edit</a>';
                                    }
                                }
                            }
                        ],
                        });
             
                $('#datatable-auction').on('click', 'tbody td:last-child button#remove', function(e){
                    e.preventDefault();

                    var self = $(this);

                    App.ajax({
                        url: ajax_auction_delete,
                        type: 'POST',
                        data: {
                            id: self.data('id')
                        }
                    }, function( data ){
                        dt.ajax.reload();
                    });

                });


                $('#betweenFilter').daterangepicker({
                    format: 'MM/DD/YYYY',
                    separator: ' to ',
                    startDate: moment().subtract(1, 'month'),
                    endDate: moment(),
                    minDate: '01/01/2012',
                    maxDate: 'moment()'
                },
                function (start, end) {
                  $('#startDate').val( start.format('YYYY-MM-D') );
                  $('#endDate').val( end.format('YYYY-MM-D') );
                  $('#betweenFilter input').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
                  });



                $('#filterForm').submit(function(e){
                    e.preventDefault();
                    $('#filterBtn').prop('disabled', 'disabled');
                    var range = $('#betweenFilter input').val().toString(), srange = range.split(' - ');
    
                    if( range == '' || range.length < 1 || srange.length !== 2 || !moment(srange[0]).isValid() || !moment(srange[0]).isValid(srange[1]) ) {
                        $('#startDate').val('');
                          $('#endDate').val('');
                          $('#betweenFilter input').val('');
                    }
    
                    dt.ajax.reload();
                });
                $( "#reset" ).click(function() {
                    $(".userSearch").select2('val', '');
                    $('.userSearch')
                    .find('option')
                    .remove()
                    .end()
                    .append('<option value=""></option>')
                    .val("");  
                  });
                $(".userSearch").select2({
                    tags: false,
                    multiple: false,
                                maximumSelectionSize: 10,
                                minimumInputLength: 1,
                    width: '400px',
                    ajax: {
                        url: ajax_admin_usersearch_select2,
                        dataType: "json",
                        type: "POST",
                        data: function(params) {
                            return {
                                q: params.term, // search term
                                page: params.page
                            };
                        },
                        processResults: function (data) {
                            var results = [];
                            $.each(data.data, function (index, user) {
                                results.push({
                                    id: user.id,
                                    text: user.username
                                });
                            });
        
                            return {
                                results: results
                            };
                        },
                        cache: true
                    }
                  });
            
            }

        }

    }();

    $(document).ready(function() {
        window.retry_dt_load = 0;
        AuctionItems.init();
    });

})();