(function(){
	var Giftcards = function() {
    return {

    	init: function() {


					$(".userSearch").select2({
            tags: false,
            multiple: false,
						maximumSelectionSize: 10,
						minimumInputLength: 1,
            width: '400px',
            ajax: {
                url: ajax_admin_usersearch_select2,
                dataType: "json",
                type: "POST",
                data: function(params) {
                    return {
                        q: params.term, // search term
                        page: params.page
                    };
                },
                processResults: function (data) {
                    var results = [];
                    $.each(data.data, function (index, user) {
                        results.push({
                            id: user.id,
                            text: user.username
                        });
                    });

                    return {
                        results: results
                    };
                },
                cache: true
            }
          });
        }
    };
  }();

	$(document).ready(function() {
		Giftcards.init();
	});

})();
