(function(){
	var Tokens = function() {

    return {

        init: function() {
        	var dt = $('#datatable-packages').on('xhr.dt', function ( e, settings, json ) {
		        $('#filterBtn').prop('disabled', false);
		    	} ).dataTable( {
						ajax: {
							url: ajax_tokens_dt,
							type: 'POST'
						},
						lengthMenu: [ 25, 50, 75, 100 ],
						pageLength: 25,
						serverSide: true,
						retrieve: true,
						paging: true,
						bStateSave: true,
						pagingType: "bootstrap_full_number",
						searching: false,
						"columns": [
					      { "title": "ID", "data": "id" },
					      { "title": "Name", "data": "name" },
					      { "title": "Price", "data": 'price' },
					      { "title": "Offset Units", "data": 'offset_units' },
					      { "title": "Resale Units", "data": "resale_units" },
					      { "title": "Wholesale Credit", "data": "wholesale_credit" },
					      { "title": "CV", "data": "cv" },
					      { "title": "Status", "data": null },
					      { "title": "Actions", "data": null, "sortable": false }
				    ],
				    "columnDefs": [
				    	{
				    		"targets": [7],
				    		"render": function ( data, type, full, meta ) {
				    			return '<span class="label label-' + ( ( full.status == 1 ) ? 'success' : 'default' ) + '"> ' + ( ( full.status ) ? 'Enabled' : 'Disabled' ) + ' </span>';
				    		}
				    	},
				    	{
				    		"targets": [8],
				    		"render": function ( data, type, full, meta ) {
				    			if( full.status == 1 ) {
				    				var status = '<button class="btn btn-danger changeStatusBtn btn-sm" style="margin-right:10px" data-action="0" data-id="' + full.id + '"><i class="fa fa-close"></i> Disable </button>';
				    			} else {
				    				var status = '<button class="btn btn-success changeStatusBtn btn-sm" style="margin-right:10px" data-action="1" data-id="' + full.id + '"><i class="fa fa-check"></i> Enable </button>';
				    			}

				    			return status + '<a href="' + tokenEdit_url + '/' + full.id + '" class="btn btn-info editBtn btn-sm"><i class="fa fa-pencil"></i> Edit</a>';
				    		}
				    	}
						]
					});

					$('#datatable-packages').on('click', 'tbody tr td:last-child .changeStatusBtn', function() {
						var id = $(this).data('id');

						App.ajax({
							url: ajax_token_status,
							type: 'POST',
							data: {
								id: id
							}
						}, function(data){
							if( data ) {
								dt.api().ajax.reload();
							}
						});

					});

        }
    };

	}();

	$(document).ready(function() {
		Tokens.init();
	});

})();
