(function(){
    var SupportCategories = function() {

        return {

            init: function() {
                var dt = new Datatable();

                dt.init({
                    src: $("#datatable-categories"),
                    onSuccess: function (grid) {
                        // execute some code after table records loaded
                    },
                    onError: function (grid) {
                        // execute some code on network or other general error
                    },
                    loadingMessage: 'Loading...',
                    dataTable: {
                        "columns": [
                            { "title": "ID", "data": "id", "sortable": true },
                            { "title": "Name", "data": "name", "sortable": true },
                            { "title": "Status", "data": null, "sortable": true },
                            { "title": "Created At", "data": "created_at", "sortable": true },
                            { "title": "Actions", "data": null, "sortable": false }
                        ],
                        "columnDefs": [
                            {
                                "targets": [2],
                                "render": function( data, type, full, meta) {
                                    return '<span class="label label-' + ( ( full.status == 1 ) ? 'success' : 'default' ) + '"> ' + ( ( full.status ) ? 'Enabled' : 'Disabled' ) + ' </span>';
                                }
                            },
                            {
                                "targets": [4],
                                "render": function ( data, type, full, meta ) {
                                    var btn = '<a href="' + admin_categories_edit + '/' + full.id + '" class="btn btn-sm yellow" id="edit"><i class="fa fa-pencil"></i> Edit</a>';

                                    if( full.status == 1 ) {
                                        btn += '<button class="btn btn-danger changeStatusBtn btn-sm" style="margin-right:10px" data-action="0" data-id="' + full.id + '"><i class="fa fa-close"></i> Disable </button>';
                                    } else {
                                        btn += '<button class="btn btn-success changeStatusBtn btn-sm" style="margin-right:10px" data-action="1" data-id="' + full.id + '"><i class="fa fa-check"></i> Enable </button>';
                                    }

                                    btn += '<button class="btn btn-sm red" id="remove" data-id="' + full.id + '"><i class="fa fa-close"></i> Delete</button>';

                                    return btn;
                                }
                                
                            }
                        ],
                        "pageLength": 25, // default record count per page
                        "ajax": {
                            "url": ajax_categories_dt // ajax source,
                        } ,
                        "order": [
                            [0, "asc"]
                        ] // set first column as a default sort by asc
                    }
                });

                $('#datatable-categories').on('click', 'tbody td:last-child button#remove', function(e){
                    e.preventDefault();

                    var self = $(this);

                    App.ajax({
                        url: ajax_categories_delete,
                        type: 'POST',
                        data: {
                            id: self.data('id')
                        }
                    }, function( data ){
                        dt.getDataTable().ajax.reload();
                    });

                });

                $('#datatable-categories').on('click', 'tbody tr td:last-child .changeStatusBtn', function() {
                        var id = $(this).data('id');

                        App.ajax({
                            url: ajax_categories_status,
                            type: 'POST',
                            data: {
                                id: id
                            }
                        }, function(data){
                            if( data ) {
                                dt.getDataTable().ajax.reload();
                            }
                        });

                    });
            }
        }

    }();

    $(document).ready(function() {
        SupportCategories.init();
    });

})();