function getDatatableLang(lang){
	var result = '';
	
	if(lang === 'en'){
		result = {
			"sEmptyTable":     "No data available in table",
			"sInfo":           "Showing _START_ to _END_ of _TOTAL_ entries",
			"sInfoEmpty":      "Showing 0 to 0 of 0 entries",
			"sInfoFiltered":   "(filtered from _MAX_ total entries)",
			"sInfoPostFix":    "",
			"sInfoThousands":  ",",
			"sLengthMenu":     "Show _MENU_ entries",
			"sLoadingRecords": "Loading...",
			"sProcessing":     "Processing...",
			"sSearch":         "Search:",
			"sZeroRecords":    "No matching records found",
			"oPaginate": {
				"sFirst":    "First",
				"sLast":     "Last",
				"sNext":     "Next",
				"sPrevious": "Previous"
			},
			"oAria": {
				"sSortAscending":  ": activate to sort column ascending",
				"sSortDescending": ": activate to sort column descending"
			}
		};
	}
	else if(lang === 'cn'){
		result = {
			"sProcessing":   "处理中...",
			"sLengthMenu":   "显示 _MENU_ 项结果",
			"sZeroRecords":  "没有匹配结果",
			"sInfo":         "显示第 _START_ 至 _END_ 项结果，共 _TOTAL_ 项",
			"sInfoEmpty":    "显示第 0 至 0 项结果，共 0 项",
			"sInfoFiltered": "(由 _MAX_ 项结果过滤)",
			"sInfoPostFix":  "",
			"sSearch":       "搜索:",
			"sUrl":          "",
			"sEmptyTable":     "表中数据为空",
			"sLoadingRecords": "载入中...",
			"sInfoThousands":  ",",
			"oPaginate": {
				"sFirst":    "首页",
				"sPrevious": "上页",
				"sNext":     "下页",
				"sLast":     "末页"
			},
			"oAria": {
				"sSortAscending":  ": 以升序排列此列",
				"sSortDescending": ": 以降序排列此列"
			}
		};
	}
	
	return result;
}

function getTranslate(key){
	var dictionary = {
		'id' : {'en': 'ID', 'cn' : 'ID'},
		'item' : {'en': 'Item', 'cn' : '条'},
		'price' : {'en': 'Price', 'cn' : '价格'},
		'status' : {'en': 'Status', 'cn' : '状态'},
		'type' : {'en': 'Type', 'cn' : '类型'},
		'purchase_date' : {'en': 'Purchase date', 'cn' : '购买日期'},
		'actions' : {'en': 'Actions', 'cn' : '条'},
		'details' : {'en': 'Details', 'cn' : '细节'},
		'auction_purchase_details' : {'en' : 'Auction Purchase Details','cn' : '拍卖购买详情'},
		'shipping_information' : {'en' : 'Shipping Information','cn' : '送货信息'},
		'piece' : {'en' : 'Piece', 'cn' : '片'},
		'name' : {'en' : 'Name', 'cn' : '名称'},
		'hash' : {'en' : 'Hash', 'cn' : '复述'},
		'amount' : {'en' : 'Amount', 'cn' : '量'},
		'usable' : {'en' : 'Usable', 'cn' : '可用'},
		'address' : {'en' : 'Address', 'cn' : '地址'},	
		'currency' : {'en' : 'Currency', 'cn' : '货币'},
		'transaction_date' : {'en' : 'Transaction date', 'cn' : '交易日期'},
		'system' : {'en' : 'System', 'cn' : '体系'},
		'comment' : {'en' : 'Comment', 'cn' : '注解'},
		'usdt_value' : {'en' : 'USDT Value', 'cn' : 'USDT价值'},
		'coin_rate' : {'en' : 'Coin Rate', 'cn' : '硬币率'},
        'ended' : {'en' : 'Ended', 'cn' : '结束'},
		'delivered' : {'en' : 'Delivered', 'cn' : '交付项目'},
		'no_mails' : {'en' : 'No Mails', 'cn' : '没有邮件'},
		'view_message' : {'en' : 'View Message', 'cn' : '查看消息'}
	};
	
	//console.log(dictionary[key][act_lang]);
	return(dictionary[key][act_lang]);
}