(function(){
	var AuctionCommon = function() {

		var doms = {
			endsAt: $('.endsAt'),
			watchlistRibbon: $('.watchlist-ribbon'),
			addWatchlistBtn: $('.add-watchlist-btn')
		},
		countdownTypes = {
			soon: '%Dd %H:%M:%S',
			default: '%Dd %H:%M:%S'
		};

		var initCountdowns = function() {
			$('.ends-at').each(function(item) {
				var elem = $(this);

				if( elem.attr('data-ended') != 1 ) {
					//console.log(elem.attr('data-ts'));
					elem.countdown(elem.attr('data-ts'), function(event) {
						if( event.offset.elapsed || event.offset.totalSeconds === 0 ) {
							var _parent = $(this).parents('.auction-item');

							if( _parent.length > 0 )
								_parent.fadeOut(300).remove();

							//$(this).attr('data-ended', 1).html(getTranslate('ended'));
                            $(this).attr('data-ended', 0);
						} else {
							if( event.offset.totalSeconds <= (5 * 60) && !$(this).hasClass('highlight') )
								$(this).addClass('highlight');

						    $(this).html(
						      event.strftime( countdownTypes[ elem.data('type') ] )
						    );
						}
				  	});

				}
			});
		};

	    return {

	    	init: function() {
	    		initCountdowns();

				doms.addWatchlistBtn.on('click', function(e) {
					//console.log('asdasd');
					var self = $(this),
						id = self.data('iid'),
						isSingle = self.hasClass('single');

					App.ajax({
						url: window.addWatchlistUrl,
						data: {
							id: id,
						}
					}, function( data ) {
                        console.log(data);
						if( data && data.data ) {
							if( data.data.result == true ) {
								//if( !isSingle ) {
                                    self.parents('.auction-item').find('.watchlist-ribbon').removeClass('hidden');
                                    self.parents('.single-auction-item').find('.ribbon.watchlist').removeClass('hidden');
                                //}
								self.addClass('active');
							} else {
								//if( !isSingle ) {
                                    self.parents('.auction-item').find('.watchlist-ribbon').addClass('hidden');
                                    self.parents('.single-auction-item').find('.ribbon.watchlist').addClass('hidden');
                                //}
								self.removeClass('active');
							}
						}
					});
				});

				/*
				$(".slider").slick({
				  infinite: false,
				  centerMode: false,
				 
				  //variableWidth: true,
				  slidesToShow: 4,
				  autoplay: true,
				  centerPadding: '50px',
				  draggable: true,
				  swipeToSlide: true
				});
				*/


	        },
	        initCountdowns: initCountdowns
	    };
  	}();

	$(document).ready(function() {

		if(document.getElementById('image-links')) {
            document.getElementById('image-links').onclick = function (event) {
                $('body').addClass('gallery-body-body');
                event = event || window.event;
                var target = event.target || event.srcElement,
                    link = target.src ? target.parentNode : target,
                    options = {index: link, event: event},
                    links = this.getElementsByTagName('a');
                blueimp.Gallery(links, options);
            };
        }

		AuctionCommon.init();
		window.AuctionCommon = AuctionCommon;
	});

})();