(function(){
	var AuctionPurchase = function() {
    	return {

	    	init: function() {

                var dt = new Datatable();

                dt.init({
                    src: $("#datatable-auctionpurchase"),
                    /*onSuccess: function (grid) {
                        // execute some code after table records loaded
                    },
                    onError: function (grid) {
                        // execute some code on network or other general error
                    },*/
                    /*loadingMessage: 'Loading...',
						lengthMenu: [ 25, 50, 75, 100 ],
						pageLength: 25,
						serverSide: true,
						retrieve: true,
						paging: true,
						searching: false,*/

                    	"language": getDatatableLang(act_lang),
                    loadingMessage: 'Loading...',
                    dataTable: {
                        "columns": [
                            {"title": getTranslate('id'), "sortable": true, "data": "id"},
                            {"title": getTranslate('item'), "sortable": true, "data": "item_id"},
                            {"title": getTranslate('price'), "sortable": true, "data": "price"},
                            {"title": getTranslate('status'), "data": "status", "sortable": true},
                            {"title": getTranslate('type'), "data": "type", "sortable": true},
                            {"title": getTranslate('purchase_date'), "data": "created_at", "sortable": true},
                            {"title": getTranslate('actions'), "data": null}
                        ],
                        "columnDefs": [
                            {
                                'targets': 6,
                                'orderable': false,
                                'className': 'text-center',
                                'data': null,
                                'render': function (data, type, full, meta) {
                                    var btn = '<button class="btn yellow viewShipping btn-sm" data-id="' + full.id + '"><i class="fa fa-eye"></i> ' + getTranslate('details') + '</button>';

                                    if (full.status !== getTranslate('delivered')) {
                                        btn += '<button class="btn btn-success changeStatusBtn btn-sm" style="margin-right:10px" data-action="3" data-id="' + full.id + '"><i class="fa fa-check"></i> ' + getTranslate('delivered') + ' </button>';
                                    }
                                    return btn;
                                }
                            },
                        ],
                        "ajax": {
                            "url": ajax_auctionpurchase_dt // ajax source,
                        }
                    }

				});

                $('#datatable-auctionpurchase').on('click', 'tbody tr td:last-child .changeStatusBtn', function() {
                    var id = $(this).data('id');
                    var code = $(this).data('action');
                    //window.active_group = $(this).parent().parent().prevAll('.group:first').children().text();

                    App.ajax({
                        url: ajax_auctionpurchase_status,
                        type: 'POST',
                        data: {
                            id: id,
                            code: code
                        }
                    }, function(data){
                        if( data ) {
                            dt.getDataTable().ajax.reload();
                        }
                    });

                });

                $('#datatable-auctionpurchase tbody').on('click', 'tr td .viewShipping', function(e) {
                    e.preventDefault();
                    var id = $(this).data('id');

                    sitename = getTranslate('auction_purchase_details');
                    window.open(shippingInfoUrl + '/' + id, getTranslate('shipping_information') + ' (#' + id + ') ' + sitename, 'height=800,width=1200');
                });
	      	}
    	};
  	}();

	$(document).ready(function() {
		AuctionPurchase.init();
	});

})();