(function(){
	var BidButler = function() {
		var icons = ['','briefcase','briefcase','chart_curve','group','arrow_switch','application_add','briefcase','package','arrow_switch','application_delete','money_delete'];
		var names = ['', 'E-Wallet Fund via Processor','E-Wallet Fund via Cashout','Interest','Commission','Transfer From Member','Misc Account Credits','E-Wallet Cashout','Purchase Plans','Transfer To Member','Misc Account Debits','Processor Cashout'];

    return {

        init: function() {
        	var dt = $('#datatable-bidbutler').on('xhr.dt', function ( e, settings, json ) {
		        $('#filterBtn').prop('disabled', false);
		    	} ).DataTable( {
						ajax: {
							url: ajax_bidbutler_dt,
							type: 'POST',
							data: function(d) {
								d.startDate = $('#startDate').val();
								d.endDate = $('#endDate').val();
								d.id = $('#bidButlerID').val();
							}
						},
						lengthMenu: [ 25, 50, 75, 100 ],
						pageLength: 25,
						serverSide: true,
						retrieve: true,
						paging: true,
						searching: false,
						"columns": [
			      			{ "title": "ID", "data": "id" },
			      			{ "title": "Item", "data": null },
					    	{ "title": "Count", "data": 'counter' },
				      		{ "title": "Date", "data": "created_at" }
				    	],
						"columnDefs": [
							{
								"targets": [1],
								"render": function ( data, type, full, meta ) {
									return full.title;
								}
							}
						]
					});

					$('#betweenFilter').daterangepicker({
	            format: 'MM/DD/YYYY',
	            separator: ' to ',
	            startDate: moment().subtract(1, 'month'),
	            endDate: moment(),
	            minDate: '01/01/2012',
	            maxDate: '12/31/2018'
            },
            function (start, end) {
              $('#startDate').val( start.format('YYYY-MM-D') );
              $('#endDate').val( end.format('YYYY-MM-D') );
              $('#betweenFilter input').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
          });

					/*var startDate = moment().subtract(1, 'month');
					var endDate = moment();
					$('#betweenFilter input').val(startDate.format('MMMM D, YYYY') + ' - ' + endDate.format('MMMM D, YYYY'));
					$('#startDate').val( startDate.format('YYYY-MM-D') );
					$('#endDate').val( endDate.format('YYYY-MM-D') );*/

					$('#filterForm').submit(function(e){
            e.preventDefault();
            $('#filterBtn').prop('disabled', 'disabled');
            var range = $('#betweenFilter input').val().toString(),
            		srange = range.split(' - ');
            if( range == '' || range.length < 1 || srange.length !== 2 || !moment(srange[0]).isValid() || !moment(srange[0]).isValid(srange[1]) ) {
            	$('#startDate').val('');
              $('#endDate').val('');
              $('#betweenFilter input').val('');
            }
            dt.ajax.reload();
	        });
        }
    };

	}();

	$(document).ready(function() {
		BidButler.init();
	});

})();
