(function(){
	var Cashouts = function() {
		var icons = ['','briefcase','briefcase','chart_curve','group','arrow_switch','application_add','briefcase','package','arrow_switch','application_delete','money_delete'];
		var names = ['', 'E-Wallet Fund via Processor','E-Wallet Fund via Cashout','Interest','Commission','Transfer From Member','Misc Account Credits','E-Wallet Cashout','Purchase Plans','Transfer To Member','Misc Account Debits','Processor Cashout'];

    return {

        init: function() {
        	var dt = $('#datatable-cashouts').on('xhr.dt', function ( e, settings, json ) {
		        $('#filterBtn').prop('disabled', false);
		    	} ).DataTable( {
						ajax: {
							url: ajax_cashouts_dt,
							type: 'POST',
							data: function(d) {
								d.source = "cashouts";
								d.startDate = $('#startDate').val();
								d.endDate = $('#endDate').val();
								d.id = $('#transactionID').val();
							}
						},
						lengthMenu: [ 25, 50, 75, 100 ],
						pageLength: 25,
						serverSide: true,
						retrieve: true,
						paging: true,
						searching: false,
						"columns": [
				      { "title": "ID", "data": "id" },
				      { "title": "Type", "data": null, "sortable": true },
				      { "title": "Amount", "data": null },
				      { "title": "Processor", "data": "processor", "sortable": true },
				      { "title": "Note/Bitcoin TX ID", "data": null, "sortable": false },
				      { "title": "Date", "data": "created_at" }
				    ],
				    "columnDefs": [
							{
					 			"targets": [1],
					 			"render": function ( data, type, full, meta ) {
					 				return '<i class="fa fa-' + icons[ full.type ] + '"></i> ' + names[ full.type ];
					 			}
							},
							{
					 			"targets": [2],
					 			"render": function ( data, type, full, meta ) {
					 				return full.amount + ' (' + full.fee + ')';
					 			}
							},
							{
								 'targets': 4,
								 'orderable': false,
								 'data': null,
								 'class': 'noteCell',
								 'render': function( full ) {
										 if( full.bitcoin_txid && full.bitcoin_txid !== null ) {
											 var url = "<a href=\'" + full.bitcoin_txid + "\' target=\'_blank\'>" + full.bitcoin_txid + "</a>";
											 return '<a tabindex="0" data-html="true" href="javascript:;" class="popovers" data-container="body" data-content="' + url + '" data-placement="top" role="button"  data-original-title="Bitcoin TX ID">' + full.bitcoin_txid.trimToLength( 25 ) + '</a>';
										 }

										 return full.note;
								 }
							},
						]
					});

					$('#datatable-cashouts tbody').on('click', 'tr td a.popovers', function(e) {
            $(this).popover({
              html: true,
              template: '<div class="popover" role="tooltip"><div class="arrow"></div><h3 class="popover-title"></h3><a href="javascript:;" class="popover-close-btn"><i class="fa fa-close"></i></a><div class="popover-content"></div></div>'
            });
          });

          $('body').on('click', '.popover .popover-close-btn', function(e) {
            $(this).parents('.popover').popover('hide');
          });

					$('#betweenFilter').daterangepicker({
	            format: 'MM/DD/YYYY',
	            separator: ' to ',
	            startDate: moment().subtract(1, 'month'),
	            endDate: moment(),
	            minDate: '01/01/2012',
	            maxDate: '12/31/2018'
            },
            function (start, end) {
              $('#startDate').val( start.format('YYYY-MM-D') );
              $('#endDate').val( end.format('YYYY-MM-D') );
              $('#betweenFilter input').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
          });

					/*var startDate = moment().subtract(1, 'month');
					var endDate = moment();
					$('#betweenFilter input').val(startDate.format('MMMM D, YYYY') + ' - ' + endDate.format('MMMM D, YYYY'));
					$('#startDate').val( startDate.format('YYYY-MM-D') );
					$('#endDate').val( endDate.format('YYYY-MM-D') );*/

					$('#filterForm').submit(function(e){
            e.preventDefault();
            $('#filterBtn').prop('disabled', 'disabled');
            var range = $('#betweenFilter input').val().toString(),
            		srange = range.split(' - ');
            if( range == '' || range.length < 1 || srange.length !== 2 || !moment(srange[0]).isValid() || !moment(srange[0]).isValid(srange[1]) ) {
            	$('#startDate').val('');
              $('#endDate').val('');
              $('#betweenFilter input').val('');
            }
            dt.ajax.reload();
	        });
        }
    };

	}();

	$(document).ready(function() {
		Cashouts.init();
	});

})();
