(function(){
	var Deposits = function() {
    	return {

	    	init: function() {
                var clipboard = new ClipboardJS('#copy-uuid-btn');

                $('#copy-uuid-btn').tooltip();

                clipboard.on('success', function(e) {
                	e.clearSelection();
                	flashElementOnce($('#deposit-address'));
                });

                clipboard.on('error', function(e) {

                });

                var dt = $('#datatable-deposits').DataTable( {
							ajax: {
								url: ajax_deposits_dt,
								type: 'POST'
							},
							lengthMenu: [ 25, 50, 75, 100 ],
							pageLength: 25,
							serverSide: true,
							retrieve: true,
							paging: true,
							searching: false,
							responsive: true,
                    		"language": getDatatableLang(act_lang),
							"columns": [
								{ "title": getTranslate('address'), "sortable": true, "data": "uuid" },
                                /*{ "title": "User ID", "sortable": true, "data": "user_id" },
					            { "title": "Email", "sortable": true, "data": "email" },*/
					            { "title": getTranslate('currency'), "sortable": true, "data": "currency_name" },
                                { "title": getTranslate('amount'), "sortable": true, "data": "currency_amount" },
                                { "title": getTranslate('transaction_date'), "sortable": true, "data": "created_at" },
                                { "title": getTranslate('system'), "sortable": false, "data": "transaction_source_system" },
								{ "title": getTranslate('comment'), "sortable": false, "data": "comment" },
                                { "title": getTranslate('usdt_value'), "sortable": false, "data": "usdt_value" },
                                { "title": getTranslate('coin_rate'), "sortable": false, "data": "coin_rate" },
                                { "title": getTranslate('status'), "sortable": false, "data": "status" }

					    ]
						});

	      }
    };
  }();

	$(document).ready(function() {
		Deposits.init();
	});

})();