(function(){
	var Downline = function() {
		
	    return {

		    init: function() {
		        var t;

		        t = $(".m_datatable").mDatatable({
		            data: {
		                type: "remote",
		                source: {
		                    read: {
		                        url: router.route('clientzone.ajax.tree.downline.table'),
		                        map: function( t ) {
		                            var e = t;
		                            return void 0 !== t.data && (e = t.data), e
		                        },
		                        headers: {
		                        	'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		                        }
		                    }
		                },
		                pageSize: 25,
		                serverPaging: true,
		                serverFiltering: true,
		                serverSorting: true
		            },
		            layout: {
		                scroll: false,
		                footer: false
		            },
		            sortable: true,
		            pagination: true,
		            toolbar: {
		                items: {
		                    pagination: {
		                        pageSizeSelect: [25, 50, 100]
		                    }
		                }
		            },
		            search: {
		                input: $("#search")
		            },
		            columns: [{
		                field: "id",
		                title: "#",
		                sortable: true,
		                filterable: false,
		                selector: false,
						width: 100,
		                textAlign: "center"
		            }, {
		                field: "username",
		                title: "Username",
		                sortable: true,
		                filterable: false,
		                selector: false,
		                width: 250
		            }, {
		                field: "levelCalc",
		                title: "Level",
		                sortable: true,
		                filterable: false,
		                selector: false,
		                width: 60
		            }, {
		                field: "date",
		                title: "Registration Date",
		                sortable: true,
		                filterable: false,
		                selector: false,
		                width: 100
		            }]
		        });

		        $("#m_form_level").on("change", function() {
		            t.search($(this).val(), "level")
		        });

		        $("#m_form_level").selectpicker();
		    }
		}

	}();

	$( document ).ready(function() {
		Downline.init();
	});

})();
