var UserUpload = function() {


    return {

        //main function
        init: function() {

            var uploadedImages = [];
            var _result = [];

            if( $('#fileupload').find('input[name="images[]"]').length > 0 ) {
                $('#fileupload').find('input[name="images[]"]').each(function(val) {
                    var val = $(this).val();

                    uploadedImages.push(val);
                    _result.push({
                        "name": val,
                        "size": "",
                        "url": window.imageStorageUrl + val,
                        "thumbnailUrl": window.imageStorageUrl + '/thumbnails/' + val
                    });
                    $(this).remove();
                });
            }

            $('#fileupload').fileupload({
                disableImageResize: false,
                autoUpload: false,
                disableImageResize: /Android(?!.*Chrome)|Opera/.test(window.navigator.userAgent),
                maxFileSize: 50000000,
                ////////////////
                acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i,
                ////////////////
                // Uncomment the following to send cross-domain cookies:
                //xhrFields: {withCredentials: true},
            }).on('fileuploaddone', function (e, data) {

                //console.log(data);

                $.each(data.result.files, function(val, key) {
                    uploadedImages.push( this.name );
                });
            });

            $('#fileupload').on('submit', function(e) {
                e.preventDefault();

                if( uploadedImages.length == 0 ) {
                    alert('You have to upload at least one image for the item.')
                    return false;
                }

                $('#fileupload').find('input[name="images[]"]').remove();

                $.each(uploadedImages, function(val, key) {
                    $('#fileupload').append('<input name="images[]" type="hidden" value="' + this + '" />');
                });

                this.submit();
            });

            $('#delete-button').on('click', function(){
                var filenames = [];
                $('.template-download').each(function(){
                    filenames.push($(this).children().eq(1).text().trim());
                    //console.log($('[role=presentation]'));
                    //console.log(element);
                });


                App.ajax({
                    url: window.ajax_kycs_delete,
                    data: {
                        files: filenames,
                        type: window.userDocType
                    },
                    method: 'POST'
                }, function( r ) {
                    if( r ) {
                        //dt.ajax.reload( );
                        $('[role=presentation]').children('tbody').empty();

                    }
                });
            });


            $('#fileupload').fileupload('option', 'done').call($('#fileupload'), $.Event('done'), {
                result: {files: _result}
            });



            var editor_config = {
                path_absolute : "/laravel-filemanager/",
                selector: "textarea.tinyeditor",
                plugins: [
                    "advlist autolink lists link image charmap print preview hr anchor pagebreak",
                    "searchreplace wordcount visualblocks visualchars code fullscreen",
                    "insertdatetime media nonbreaking save table contextmenu directionality",
                    "emoticons template paste textcolor colorpicker textpattern"
                ],
                toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image media",
                relative_urls: false,
                file_browser_callback : function(field_name, url, type, win) {
                    var x = window.innerWidth || document.documentElement.clientWidth || document.getElementsByTagName('body')[0].clientWidth;
                    var y = window.innerHeight|| document.documentElement.clientHeight|| document.getElementsByTagName('body')[0].clientHeight;

                    var cmsURL = editor_config.path_absolute + '?field_name=' + field_name;
                    if (type == 'image') {
                        cmsURL = cmsURL + "&type=Images";
                    } else {
                        cmsURL = cmsURL + "&type=Files";
                    }

                    tinyMCE.activeEditor.windowManager.open({
                        file : cmsURL,
                        title : 'Filemanager',
                        width : x * 0.8,
                        height : y * 0.8,
                        resizable : "yes",
                        close_previous : "no"
                    });
                }
            };
        }

    };

}();







/*if (App.isAngularJsApp() === false) { 
    jQuery(document).ready(function() {
        Profile.init();
    });
}*/

jQuery(document).ready(function() {
    UserUpload.init();
		

});

