(function(){
    var AuctionItems = function() {

        return {

            init: function() {
                var grid = new Datatable();

                grid.init({
                    src: $("#datatable-auction"),
                    onSuccess: function (grid) {
                        // execute some code after table records loaded
                    },
                    onError: function (grid) {
                        // execute some code on network or other general error
                    },
                    loadingMessage: 'Loading...',
                    dataTable: {
                        "columns": [
                            { "title": "ID", "data": "id", "sortable": true },
                            { "title": "Title", "data": "title", "sortable": true },
                            { "title": "Category", "data": "category_name", "sortable": true },
                            { "title": "Current Price", "data": "current_price", "sortable": true },
                            { "title": "Buy Price", "data": "buy_price", "sortable": true },
                            { "title": "Ends", "data": "ends_at", "sortable": true },
                            { "title": "Actions", "data": null, "sortable": false }
                        ],
                        "columnDefs": [
                            {
                                "targets": [6],
                                "render": function ( data, type, full, meta ) {
                                    return '<a href="' + url_admin_auction_edit + '/' + full.id + '" class="btn btn-sm yellow" id="edit"><i class="fa fa-pencil"></i> Edit</a><button class="btn btn-sm red" id="remove" data-id="' + full.id + '"><i class="fa fa-close"></i> Delete</button>';
                                }
                            }
                        ],
                        "pageLength": 25, // default record count per page
                        "ajax": {
                            "url": ajax_auction_dt // ajax source,
                        } ,
                        "order": [
                            [0, "asc"]
                        ] // set first column as a default sort by asc
                    }
                });

                $('#datatable-auction').on('click', 'tbody td:last-child button#remove', function(e){
                    e.preventDefault();

                    var self = $(this);

                    App.ajax({
                        url: ajax_auction_delete,
                        type: 'POST',
                        data: {
                            id: self.data('id')
                        }
                    }, function( data ){
                        grid.getDataTable().ajax.reload();
                    });

                });
            }
        }

    }();

    $(document).ready(function() {
        AuctionItems.init();
    });

})();