(function(){
    var GiftCardsIndex = function() {

        return {

            init: function() {
                var grid = new Datatable();

                grid.init({
                    src: $("#datatable-giftcards"),
                    onSuccess: function (grid) {
                        // execute some code after table records loaded
                    },
                    onError: function (grid) {
                        // execute some code on network or other general error
                    },
                    loadingMessage: 'Loading...',
                    dataTable: {
                        "columns": [
                            { "title": "ID", "data": "id", "sortable": true },
                            { "title": "Hash", "data": "hash", "sortable": true },
                            { "title": "Amount", "data": "amount", "sortable": true },
                            { "title": "Created", "data": "created_at", "sortable": true },
                            { "title": "Actions", "data": null, "sortable": false }
                        ],
                        "columnDefs": [
                            {
                                "targets": [4],
                                "render": function ( data, type, full, meta ) {
                                    return '<button class="btn btn-sm red" id="remove" data-id="' + full.id + '"><i class="fa fa-close"></i> Delete</button>';
                                }
                            }
                        ],
                        "pageLength": 25, // default record count per page
                        "ajax": {
                            "url": ajax_giftcards_dt // ajax source,
                        } ,
                        "order": [
                            [0, "asc"]
                        ] // set first column as a default sort by asc
                    }
                });

                $('#datatable-giftcards').on('click', 'tbody td:last-child button#remove', function(e){
                    e.preventDefault();

                    var self = $(this);

                    App.ajax({
                        url: ajax_giftcards_delete,
                        type: 'POST',
                        data: {
                            id: self.data('id')
                        }
                    }, function( data ){
                        grid.getDataTable().ajax.reload();
                    });

                });
            }
        }

    }();

    $(document).ready(function() {
        GiftCardsIndex.init();
    });

})();
