(function(){
	var Transactions = function() {
		var icons = ['','briefcase','briefcase','chart_curve','group','arrow_switch','application_add','briefcase','package','arrow_switch','application_delete','money_delete'];
		var names = ['', 'E-Wallet Fund via Processor','E-Wallet Fund via Cashout','Interest','Commission','Transfer From Member','Misc Account Credits','E-Wallet Cashout','Purchase Plans','Transfer To Member','Misc Account Debits','Processor Cashout'];

    return {

    	init: function() {
				var dt = $('#datatable-transactions').on('xhr.dt', function ( e, settings, json ) {
		        $('#searchBtn').prop('disabled', false);
		    	} ).DataTable( {
						ajax: {
							url: ajax_transactions_dt,
							type: 'POST',
							data: function(d) {
								d.source = "transactions";
                d.id = $('#id').val();
                d.user_id = $('#user_id').val();
                d.type = $('#type').val();
                d.amount = $('#amount').val();
                d.processor = $('#processor').val();
                d.note = $('#note').val();
                d.startDate = $('#startDate').val();
                d.endDate = $('#endDate').val();
							}
						},
						lengthMenu: [ 25, 50, 75, 100 ],
						pageLength: 25,
						serverSide: true,
						retrieve: true,
						paging: true,
						searching: false,
						"columns": [
              { "title": "Transaction ID", "sortable": true, "data": "id" },
              { "title": "Member", "data": "user_id", "sortable": true },
              { "title": "Type", "data": "type", "sortable": false },
              { "title": "Amount", "data": "amount" },
              { "title": "Balance", "data": "balance" },
              { "title": "Processor", "data": "processor", "sortable": false },
              { "title": "Note", "data": "note", "sortable": false },
              { "title": "Date", "data": "created_at" }
				    ],
				    "columnDefs": [
              {
                  "targets": [0],
                  "render": function ( data, type, full, meta ) {
                      return names[ full.type ] + ' (#' + full.id + ')';
                  }
              },
              {
                  "targets": [1],
                  "render": function ( data, type, full, meta ) {
                      return '<a href="#" class="userPopup" data-id="' + full.user_id + '">' + full.username + ' (#' + full.user_id + ')</a>';
                  }
              },
              {
                  "targets": [2],
                  "render": function ( data, type, full, meta ) {
                      return full.typeName;
                  }
              },
              {
                  'targets': 5,
                  'orderable': true,
                  'data': null,
                  'render': function( data, type, full, meta ) {
                     return '<img src="' + processorImgUrl + full.processor_id + '.gif" />'
                  }
               },
            ]
					});

      $('#datatable-transactions tbody').on('click', 'tr td a.userPopup', function(e) {
            e.preventDefault();
            var id = $(this).data('id');

            App.userInfo( id, userInfoUrl );
         });

			$('#betweenFilter').daterangepicker({
	            format: 'MM/DD/YYYY',
	            separator: ' to ',
	            startDate: moment().subtract(1, 'month'),
	            endDate: moment(),
	            minDate: '01/01/2012',
	            maxDate: '12/31/2018'
            },
            function (start, end) {
              $('#startDate').val( start.format('YYYY-MM-D') );
              $('#endDate').val( end.format('YYYY-MM-D') );
              $('#betweenFilter input').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
          	});

			$('#filterForm').submit(function(e){
	            e.preventDefault();

	            $('#filterBtn').prop('disabled', 'disabled');
	            var range = $('#betweenFilter input').val().toString(), srange = range.split(' - ');

	            if( range == '' || range.length < 1 || srange.length !== 2 || !moment(srange[0]).isValid() || !moment(srange[0]).isValid(srange[1]) ) {
	            	$('#startDate').val('');
	              	$('#endDate').val('');
	              	$('#betweenFilter input').val('');
	            }

	            dt.ajax.reload();
	        });

					$(".userSearch").select2({
            tags: false,
            multiple: false,
						maximumSelectionSize: 10,
						minimumInputLength: 1,
            width: '400px',
            ajax: {
                url: ajax_admin_usersearch_select2,
                dataType: "json",
                type: "POST",
                data: function(params) {
                    return {
                        q: params.term, // search term
                        page: params.page
                    };
                },
                processResults: function (data) {
                    var results = [];
                    $.each(data.data, function (index, user) {
                        results.push({
                            id: user.id,
                            text: user.username
                        });
                    });

                    return {
                        results: results
                    };
                },
                cache: true
            }
          });
        }
    };
  }();

	$(document).ready(function() {
		Transactions.init();
	});

})();
