(function(){
	var ReportUploader = function() {

    return {

    	init: function() {
				var dt = $('.datatable-reports').DataTable( {
						ajax: {
							url: ajax_reports_dt,
							type: 'POST'
						},
						lengthMenu: [ 25, 50, 75, 100 ],
						pageLength: 25,
						serverSide: true,
						retrieve: true,
						paging: true,
						searching: false,
						"columns": [
              { "title": "ID", "sortable": true, "data": "id" },
              { "title": "File #1", "data": "file_1", "sortable": false },
              { "title": "File #2", "data": "file_2", "sortable": false },
              { "title": "Date", "data": "date", "sortable": true },
              { "title": "Week", "data": "week", "sortable": false }
				    ],
				    "columnDefs": [
              {
                  "targets": [0],
                  "render": function ( data, type, full, meta ) {
                      return '#' + full.id;
                  }
              },
              {
                  "targets": [1],
                  "render": function ( data, type, full, meta ) {
                      return '<a href="' + reportFile_url + '/' + full.id + '/1" class="btn btn-success btn-sm" target="_blank"><i class="fa fa-eye"></i> View</a>';
                  }
              },
              {
                  "targets": [2],
                  "render": function ( data, type, full, meta ) {
                      return '<a href="' + reportFile_url + '/' + full.id + '/2" class="btn btn-success btn-sm"  target="_blank"><i class="fa fa-eye"></i> View</a>';
                  }
              },
              {
                  "targets": [5],
                  "render": function ( data, type, full, meta ) {
                      return '<button class="btn btn-sm btn-danger deleteReport" data-id="' + full.id + '"><i class="fa fa-trash"></i> Delete</button>';
                  }
              }
            ]
					});

          $('.datatable-reports').on('click', 'tbody tr td button.deleteReport', function(e) {
            var self = $(this),
                id = self.data('id');

                App.ajax({
                  url: ajax_reports_delete,
                  data: {
                    id: id
                  },
                  method: 'POST'
                }, function( r ) {
                  if( r ) {
                    dt.ajax.reload( );
                  }
                });
          });

        }
    };
  }();

	$(document).ready(function() {
		ReportUploader.init();
	});

})();
