(function(){
    var Support = function () {

        // private functions & variables

        var _initComponents = function() {
            var editor_config = {
                path_absolute : "/laravel-filemanager/",
                selector: "textarea.tinyeditor",
                plugins: [
                    "advlist autolink lists link image charmap print preview hr anchor pagebreak",
                    "searchreplace wordcount visualblocks visualchars code fullscreen",
                    "insertdatetime media nonbreaking save table contextmenu directionality",
                    "emoticons template paste textcolor colorpicker textpattern"
                ],
                toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image media",
                relative_urls: true,
                file_browser_callback : function(field_name, url, type, win) {
                    var x = window.innerWidth || document.documentElement.clientWidth || document.getElementsByTagName('body')[0].clientWidth;
                    var y = window.innerHeight|| document.documentElement.clientHeight|| document.getElementsByTagName('body')[0].clientHeight;

                    var cmsURL = editor_config.path_absolute + '?field_name=' + field_name;
                    if (type == 'image') {
                        cmsURL = cmsURL + "&type=Images";
                    } else {
                        cmsURL = cmsURL + "&type=Files";
                    }

                    tinyMCE.activeEditor.windowManager.open({
                        file : cmsURL,
                        title : 'Filemanager',
                        width : x * 0.8,
                        height : y * 0.8,
                        resizable : "yes",
                        close_previous : "no"
                    });
                }
            };

            tinymce.init(editor_config);

            $('form.sendReply').submit( function (e) {
                $('textarea[name="content"]').html($('.summernote').code());
            });

            $('a.support-reply-load').on('click', function (e) {
                e.preventDefault();

                var value = $('#stored_replies').val();

                $.ajax({
                  type: 'POST',
                  url: load_content_ajax_url,
                  data: {
                    id: value
                  },
                  success: function( data ) {
                    tinymce.activeEditor.setContent( data[0], {format : 'raw'} );
                  }
                });
            });
        }

        var _handleProjectListMenu = function() {
            if (App.getViewPort().width <= 992) {
                $('.support-project-list-content').addClass("collapse");
            } else {
                $('.support-project-list-content').removeClass("collapse").css("height", "auto");
            }
        }

        // public functions
        return {

            //main function
            init: function () {
                _initComponents();     
                _handleProjectListMenu();

                App.addResizeHandler(function(){
                    _handleProjectListMenu();    
                });    
            }

        };

    }();

    $(document).ready(function() {
        Support.init();
    });
})();