(function(){
	var UsersAccounting = function() {
		var icons = ['','briefcase','briefcase','chart_curve','group','arrow_switch','application_add','briefcase','package','arrow_switch','application_delete','money_delete'];
		var names = ['', 'E-Wallet Fund via Processor','E-Wallet Fund via Cashout','Interest','Commission','Transfer From Member','Misc Account Credits','E-Wallet Cashout','Purchase Plans','Transfer To Member','Misc Account Debits','Processor Cashout'];

    return {

    	init: function() {
						$('#betweenFilter').daterangepicker({
	            format: 'MM/DD/YYYY',
	            separator: ' to ',
	            startDate: moment().subtract(1, 'month'),
	            endDate: moment(),
	            minDate: '01/01/2012',
	            maxDate: '12/31/2018'
            },
            function (start, end) {
              $('#startDate').val( start.format('YYYY-MM-D') );
              $('#endDate').val( end.format('YYYY-MM-D') );
              $('#betweenFilter input').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
          	});

					$('#filterForm').submit(function(e){
	            e.preventDefault();
	            
	            $('#filterBtn').prop('disabled', 'disabled');
	            var range = $('#betweenFilter input').val().toString(), srange = range.split(' - ');

	            if( range == '' || range.length < 1 || srange.length !== 2 || !moment(srange[0]).isValid() || !moment(srange[0]).isValid(srange[1]) ) {
	            		$('#startDate').val('');
	              	$('#endDate').val('');
	              	$('#betweenFilter input').val('');
	            }

	            var startDate = $('#startDate').val();
              var endDate = $('#endDate').val();

	            App.ajax({
	            	url: ajax_accounting_data,
	            	type: 'POST',
	            	data: {
	            		userID: $('#userID').val(),
	            		startDate: startDate,
	            		endData: endDate
	            	}
	            }, function( data ){
	            	$('#filterBtn').prop('disabled', false);

	            	var tables = {
	            		credit: $('table.credit'),
	            		debit: $('table.debit'),
	            		cashout: $('table.cashout')
	            	};

	            	for( var t in tables ) {
	            		var table = tables[ t ];

	            		for( var i in data[ t ] ) {
	            			var item = data[ t ][ i ];

	            			table.find('tr.' + i).find('td.value').html( item );
	            		}

	            	}

	            });
	        });

	        $(".userSearch").select2({
			      tags: false,
			      multiple: false,
			      width: '400px',
			      ajax: {
			          url: ajax_admin_usersearch_select2,
			          dataType: "json",
			          type: "POST",
			          data: function(params) {
			              return {
			                  q: params.term, // search term
			                  page: params.page
			              };
			          },
			          processResults: function (data) {
			              var results = [];
			              $.each(data.data, function (index, user) {
			                  results.push({
			                      id: user.id,
			                      text: user.username
			                  });
			              });

			              return {
			                  results: results
			              };
			          },
			          formatResult: function(element){
					          return element.text + ' (' + element.id + ')';
					      },
					      formatSelection: function(element){
					          return element.text + ' (' + element.id + ')';
      					},
			          cache: true
			      }
			  	});

			  	//$(".userSearch").select2().select2('data', defaultUser[0]); 

					$('#filterForm').trigger('submit');

        }
    };
  }();

	$(document).ready(function() {
		UsersAccounting.init();
	});

})();