(function(){
	var AuctionCommon = function() {

		var doms = {
			endsAt: $('.endsAt'),
			watchlistRibbon: $('.watchlist-ribbon'),
			addWatchlistBtn: $('.add-watchlist-btn')
		},
		countdownTypes = {
			soon: '%H:%M:%S'
		};

		var initCountdowns = function() {
			$('.ends-at').each(function(item) {
				var elem = $(this);

				if( elem.data('ended') != 1 ) {

					elem.countdown(elem.data('ts'), function(event) {
						if( event.offset.elapsed || event.offset.totalSeconds === 0 ) {
							var _parent = $(this).parents('.auction-item');

							if( _parent.length > 0 )
								_parent.fadeOut(300).remove();

							$(this).data('ended', 1).html('Ended');
						} else {
							if( event.offset.totalSeconds <= (5 * 60) && !$(this).hasClass('highlight') )
								$(this).addClass('highlight');

						    $(this).html(
						      event.strftime( countdownTypes[ elem.data('type') ] )
						    );
						}
				  	});

				}
			});
		};

	    return {

	    	init: function() {
	    		initCountdowns();

				doms.addWatchlistBtn.on('click', function(e) {
					var self = $(this),
						id = self.data('iid'),
						isSingle = self.hasClass('single');

					App.ajax({
						url: window.addWatchlistUrl,
						data: {
							id: id,
						}
					}, function( data ) {
						if( data && data.data ) {
							if( data.data.result == true ) {
								if( !isSingle )
									self.parents('.auction-item').find('.watchlist-ribbon').removeClass('hidden');

								self.addClass('active');
							} else {
								if( !isSingle )
									self.parents('.auction-item').find('.watchlist-ribbon').addClass('hidden');

								self.removeClass('active');
							}
						}
					});
				});

				$(".slider").slick({
				  infinite: false,
				  centerMode: false,
				 
				  //variableWidth: true,
				  slidesToShow: 4,
				  autoplay: true,
				  centerPadding: '50px',
				  draggable: true,
				  swipeToSlide: true
				});
	        },
	        initCountdowns: initCountdowns
	    };
  	}();

	$(document).ready(function() {
		AuctionCommon.init();
		window.AuctionCommon = AuctionCommon;
	});

})();