(function(){
	var Certificates = function() {
    return {

    	init: function() {
				var dt = $('#datatable-certificates').DataTable( {
						ajax: {
							url: ajax_certificates_dt,
							type: 'POST'

						},
						lengthMenu: [ 25, 50, 75, 100 ],
						pageLength: 25,
						serverSide: true,
						retrieve: true,
						paging: true,
						searching: false,
						"columns": [
			              { "title": "Issue Name", "data": "name" },
			              { "title": "Units", "data": "amount" },
			              { "title": "Description", "data": 'description' },
			              { "title": "Status", "data": "status", "sortable":false },
			              { "title": "Certificate", "data": null, "sortable": false }
			            ],
				    	"columnDefs": [
				    		{
			                  "targets": [3],
			                  "render": function ( data, type, full, meta ) {
			                      return (full.status == 0) ? '-' : '-';
			                  }
			              },
			              {
			                  "targets": [4],
			                  "render": function ( data, type, full, meta ) {
			                      return '<a href="' + url_certificate_view + '/' + full.id + '" target="_blank" class="btn btn-sm yellow"><i class="fa fa-eye"></i></a> <a href="' + url_certificate_download + '/' + full.id + '" target="_blank" class="btn btn-sm yellow"><i class="fa fa-cloud"></i></a>';
			                  }
			              }
			            ]
			});
        }
    };
  }();

	$(document).ready(function() {
		Certificates.init();
	});

})();