(function(){
	var GreenShillingBuy = function() {
    return {

    	init: function() {
			var dt = $('#datatable-slothistory').DataTable( {
				ajax: {
					url: ajax_slothistory_dt,
					type: 'POST'
				},
				lengthMenu: [ 25, 50, 75, 100 ],
				pageLength: 25,
				serverSide: true,
				retrieve: true,
				paging: true,
				searching: false,
					"columns": [
		              { "title": "Mining Slots", "sortable": true, "data": "slots" },
		              { "title": "Units", "data": "units", "sortable": true },
		              { "title": "Mining Period", "data": null, "sortable": true },
		              { "title": "Wallet Address", "data": "wallet", "sortable": true },
		              { "title": "Created", "data": "created_at" }
			    ],
			    "columnDefs": [
	              {
	                  "targets": [2],
	                  "render": function ( data, type, full, meta ) {
	                      return full.period_from + ' - ' + full.period_to;
	                  }
	              }
	            ]
			});

			function u(v){var b=$('.btn-block');
		        if(v>100||v===0){b.prop('disabled',true);}else{b.prop('disabled',false);}
		    }

		    $('#slotsAmount').keyup(function () {
		        var a = $(this), v = a.val();
		        $('#totalPrice').text(Number(v) * Number('100'));
		        u(v);
		    });

		    $("form#BuyMiningSlots").validate({
		      errorElement: 'span', //default input error message container
		      errorClass: 'help-block help-block-error', // default input error message class
		      focusInvalid: false, // do not focus the last invalid input
		      ignore: "",  // validate all fields including form hidden input
		      rules: {
		        slotsAmount: {
		            minlength: 1,
		            number: true,
		            required: true
		        },
		        walletAddress: {
		          required: true,
		          //pattern: /^g[a-zA-Z0-9]{32,}$/
		        },
		        secondaryPassword: {
		          required: true,
		          minlength: 5
		        }
		      },
		      errorPlacement: function(error, element) {
		        error.appendTo( element.parents(".form-group") );
		      },
		      highlight: function (element) { // hightlight error inputs

		          $(element)
		              .parents('.form-group').addClass('has-error'); // set error class to the control group
		      },

		      unhighlight: function (element) { // revert the change done by hightlight
		          $(element)
		              .parents('.form-group').removeClass('has-error'); // set error class to the control group
		      },

		      success: function (label) {
		          label
		              .parents('.form-group').removeClass('has-error'); // set success class to the control group
		      },

		      submitHandler: function (form) {
		      	form.submit();
		      }
		    });
        }
    };
  }();

	$(document).ready(function() {
		GreenShillingBuy.init();
	});

})();