(function(){
	var Withdrawal = function() {

		var calculateFee = function(fee, amount) {

		    amount = ( !amount || amount == '' ) ? 0.00 : parseFloat(amount);

		    if( fee == 0 ) {
		      var net = amount;
		      $('#fee_static').find('span#_fee').html(parseFloat(0.00).toFixed(2));
		    } else {
		      var fee_amount = ( fee / 100 ) * amount;
		      net = amount - fee_amount;
		      $('#fee_static').find('span#_fee').html(parseFloat(fee_amount).toFixed(2));
		    }

		    $('#fee_static').find('span#_net').html(parseFloat(net).toFixed(2));
		    
		};

	    return {

	        init: function() {

	        	$('select#processor').on('change', function(){
	        		var o = $('select#processor option:selected');
				    var fee = o.data('fee');
				    var val = $('input#amount').val();

				    calculateFee(fee, val);
				});

				$('input#amount').on('keyup', function(){
					var o = $('select#processor option:selected');
					var fee = o.data('fee');
					var val = $(this).val();

					calculateFee(fee, val);
				});
	           
	        }
	    };

	}();

	$(document).ready(function() {
	    Withdrawal.init(); // init metronic core componets
	});
})();