(function(){ 
    var ProfileVerify = function () {

        return {
            //main function to initiate the module
            init: function () {
                var form = $('#verify_form');
                var error = $('.alert-danger', form);
                var success = $('.alert-success', form);

                $.validator.addMethod('filesize', function(value, element, param) {
                    // param = size (en bytes) 
                    // element = element to validate (<input>)
                    // value = value of the element (file name)
                    return this.optional(element) || (element.files[0].size <= param) 
                });

                form.validate({
                    doNotHideMessage: true, //this option enables to show the error/success messages on tab switch.
                    errorElement: 'span', //default input error message container
                    errorClass: 'help-block help-block-error', // default input error message class
                    focusInvalid: false, // do not focus the last invalid input
                    rules: {
                        //account
                        ssn: {
                            minlength: 9,
                            required: true
                        },
                        itin: {
                            minlength: 9,
                            required: true
                        },
                        phone: {
                            minlength: 5,
                            required: true
                        },

                        // docs
                        doc_id_type: {
                            required: true
                        },
                        doc_id_value: {
                            required: true
                        },
                        doc_id: {
                            required: true,
                            filesize: 10000000,
                            extension: 'doc|docx|png|jpg|jpeg|pdf'
                        },
                        doc_address_type: {
                            required: true
                        },
                        doc_address: {
                            required: true,
                            filesize: 10000000,
                            extension: 'doc|docx|png|jpg|jpeg|pdf'
                        }
                    },

                    messages: {
                        doc_id: "File must be doc,docx,png,jpg,pdf and less than 10MB",
                        doc_address: "File must be doc,docx,png,jpg,pdf and less than 10MB"
                    },

                    errorPlacement: function (error, element) { // render error placement for each input type
                        if (element.attr("name") == "gender") { // for uniform radio buttons, insert the after the given container
                            error.insertAfter("#form_gender_error");
                        } else if (element.attr("name") == "payment[]") { // for uniform checkboxes, insert the after the given container
                            error.insertAfter("#form_payment_error");
                        } else {
                            error.insertAfter(element); // for other inputs, just perform default behavior
                        }
                    },

                    invalidHandler: function (event, validator) { //display error alert on form submit   
                        success.hide();
                        error.show();
                        App.scrollTo(error);
                    },

                    highlight: function (element) { // hightlight error inputs
                        $(element)
                            .closest('.form-group').removeClass('has-success').addClass('has-error'); // set error class to the control group
                    },

                    unhighlight: function (element) { // revert the change done by hightlight
                        $(element)
                            .closest('.form-group').removeClass('has-error'); // set error class to the control group
                    },

                    success: function (label) {
                       
                    },

                    submitHandler: function (form) {
                        success.show();
                        error.hide();
                        //add here some ajax code to submit your form or just call form.submit() if you want to submit the form without ajax
                        form.submit();
                    }

                });

                var displayConfirm = function() {
                    $('#tab4 .form-control-static', form).each(function(){
                        var input = $('[name="'+$(this).attr("data-display")+'"]', form);
                        if (input.is(":radio")) {
                            input = $('[name="'+$(this).attr("data-display")+'"]:checked', form);
                        }
                        if (input.is(":text") || input.is("textarea")) {
                            $(this).html(input.val());
                        } else if (input.is("select")) {
                            $(this).html(input.find('option:selected').text());
                        } else if (input.is(":radio") && input.is(":checked")) {
                            $(this).html(input.attr("data-title"));
                        } else if ($(this).attr("data-display") == 'payment[]') {
                            var payment = [];
                            $('[name="payment[]"]:checked', form).each(function(){ 
                                payment.push($(this).attr('data-title'));
                            });
                            $(this).html(payment.join("<br>"));
                        }
                    });
                }

                var handleTitle = function(tab, navigation, index) {
                    var total = navigation.find('li').length;
                    var current = index + 1;
                    // set wizard title
                    $('.step-title', $('#verify_wizard_1')).text('Step ' + (index + 1) + ' of ' + total);
                    // set done steps
                    $('li', $('#verify_wizard_1')).removeClass("done");
                    var li_list = navigation.find('li');
                    for (var i = 0; i < index; i++) {
                        $(li_list[i]).addClass("done");
                    }

                    if (current == 1) {
                        $('#verify_wizard_1').find('.button-previous').hide();
                    } else {
                        $('#verify_wizard_1').find('.button-previous').show();
                    }

                    if (current >= total) {
                        $('#verify_wizard_1').find('.button-next').hide();
                        $('#verify_wizard_1').find('.button-submit').show();
                        displayConfirm();
                    } else {
                        $('#verify_wizard_1').find('.button-next').show();
                        $('#verify_wizard_1').find('.button-submit').hide();
                    }

                    App.scrollTo($('.breadcrumb'));
                }

                // default form wizard
                $('#verify_wizard_1').bootstrapWizard({
                    'nextSelector': '.button-next',
                    'previousSelector': '.button-previous',
                    onTabClick: function (tab, navigation, index, clickedIndex) {
                        return false;
                        
                        success.hide();
                        error.hide();
                        if (form.valid() == false) {
                            return false;
                        }
                        
                        handleTitle(tab, navigation, clickedIndex);
                    },
                    onNext: function (tab, navigation, index) {
                        success.hide();
                        error.hide();

                        if (form.valid() == false) {
                            return false;
                        }

                        handleTitle(tab, navigation, index);
                    },
                    onPrevious: function (tab, navigation, index) {
                        success.hide();
                        error.hide();

                        handleTitle(tab, navigation, index);
                    },
                    onTabShow: function (tab, navigation, index) {
                        var total = navigation.find('li').length;
                        var current = index + 1;
                        var $percent = (current / total) * 100;
                        $('#verify_wizard_1').find('.progress-bar').css({
                            width: $percent + '%'
                        });
                    }
                });

                $('#verify_wizard_1').find('.button-previous').hide();
                $('#verify_wizard_1 .button-submit').click(function () {
                    form.submit();
                }).hide();

                //apply validation on select2 dropdown value change, this only needed for chosen dropdown integration.
                $('#country_list', form).change(function () {
                    form.validate().element($(this)); //revalidate the chosen dropdown value and show error or success message for the input
                });

                $("#ssn").inputmask("999-99-9999", {
                    placeholder: " ",
                    clearMaskOnLostFocus: true
                });

                $("#itin").inputmask({
                    "mask": "99-9999999",
                    placeholder: ""
                });

                $("#phone").inputmask("mask", {
                    "mask": "(999) 999-9999"
                });
            }

        };

    }();

    $(document).ready(function() {
        ProfileVerify.init();
    });
})();