(function(){
  var Wallet = function() {
    return {

      init: function() {
          var calculateFee = function(fee, amount) {

            amount = ( !amount || amount == '' ) ? 0.00 : parseFloat(amount);

            if( fee == 0 ) {
              var net = amount;
              $('#fee_static').find('span#_fee').html(parseFloat(0.00).toFixed(2));
            } else {
              var fee_amount = ( fee / 100 ) * amount;
              net = amount - fee_amount;
              $('#fee_static').find('span#_fee').html(parseFloat(fee_amount).toFixed(2));
            }

            $('#fee_static').find('span#_net').html(parseFloat(net).toFixed(2));

          };

          $('#amount_transfer').on('keyup', function(){
            var o = $('.select-processor-fund').find('option:selected');

            var fee = o.data('fee');
            var val = $(this).val();

            calculateFee(fee, val);
          });

          $('.select-processor-fund').on('change', function(){
              var fee = $('.select-processor-fund option:selected').data('fee');
              var val = $('#amount_transfer').val();

              if( $(this).val() == 6 ) {
                $('#amount-container').hide();
                $('#fee-container').hide();
                $('#gc-container').removeClass('hidden');
              } else {
                $('#gc-container').addClass('hidden');
                $('#amount-container').show();
                $('#fee-container').show();
                calculateFee(fee, val);
              }

          });

          $('.select-processor-fund').trigger('change');

          $('#fund_form').submit(function(e){
            var processor = $('.select-processor-fund').find('option:selected').val();
            console.log(processor);

            if( processor == 2 || processor == 3 ) {
              console.log('Other');
              e.preventDefault();

              var form = $('#form_processor_' + processor );
              form.find('#extra1').val($('#amount_transfer').val());
              form.find('#extra2').val();
              form.submit();
            } else {
              console.log('Send');
              return true;
            }

          });

          $('input#amount').on('keyup', function(){
            var val = parseFloat($(this).val());
            var total_cost = $('#total_cost').children('span');

            if( !val || val == '' ) {
              total_cost.html('0.00');
            } else {
              total_cost.html( parseFloat(val).toFixed(2) );
            }
          });

          $.fn.editable.defaults.mode = 'inline';
          $.fn.editable.defaults.inputclass = 'form-control';
          $.fn.editable.defaults.url = '/post';

          $('#bitcoin_txid').editable({
            url: ajax_url_postBitcoinTxId,
            type: 'text',
            name: 'bitcoin_txid',
            title: 'Enter Bitcoin TX ID'
        });

        }
    };
  }();

  $(document).ready(function() {
    Wallet.init();
  });

})();
